/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.wormhole.portal.IPortalGroupEntity;
import com.supermartijn642.wormhole.portal.PortalGroup;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class GeneratorBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
IEnergyStorage {
    private static final int BLOCKS_PER_TICK = 5;
    protected int energy;
    protected final int energyCapacity;
    private final int energyRange;
    private final int energyTransferLimit;
    private final Set<BlockPos> portalBlocks = new LinkedHashSet<BlockPos>();
    private final HashMap<BlockPos, Direction> energyBlocks = new HashMap();
    private int searchX;
    private int searchY;
    private int searchZ;

    public GeneratorBlockEntity(BaseBlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int energyCapacity, int energyRange, int energyTransferLimit) {
        super(blockEntityType, pos, state);
        this.energyCapacity = energyCapacity;
        this.energyRange = energyRange;
        this.energyTransferLimit = energyTransferLimit;
        this.searchY = this.searchZ = -energyRange;
        this.searchX = this.searchZ;
    }

    public void update() {
        if (!this.level.isClientSide) {
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = this.worldPosition.offset(this.searchX, this.searchY, this.searchZ);
                if (!pos.equals((Object)this.worldPosition)) {
                    BlockEntity entity = this.level.getBlockEntity(pos);
                    if (entity instanceof IPortalGroupEntity && ((IPortalGroupEntity)entity).hasGroup()) {
                        if (!this.portalBlocks.contains(pos) || this.energyBlocks.containsKey(pos)) {
                            this.portalBlocks.add(pos);
                            this.energyBlocks.remove(pos);
                            this.dataChanged();
                        }
                    } else {
                        boolean bl = false;
                        Direction inputSide = Direction.UP;
                        if (entity != null) {
                            for (Direction side : Direction.values()) {
                                IEnergyStorage storage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, null, entity, (Object)side);
                                if (storage == null || !storage.canReceive()) continue;
                                bl = true;
                                inputSide = side;
                                break;
                            }
                        }
                        if (bl && this.energyBlocks.get(pos) != inputSide) {
                            this.energyBlocks.put(pos, inputSide);
                            this.dataChanged();
                        } else if (!bl && this.energyBlocks.containsKey(pos)) {
                            this.energyBlocks.remove(pos);
                            this.dataChanged();
                        }
                        if (this.portalBlocks.contains(pos)) {
                            this.portalBlocks.remove(pos);
                            this.dataChanged();
                        }
                    }
                }
                ++this.searchX;
                if (this.searchX <= this.energyRange) continue;
                this.searchX = -this.energyRange;
                ++this.searchZ;
                if (this.searchZ <= this.energyRange) continue;
                this.searchZ = -this.energyRange;
                ++this.searchY;
                if (this.searchY <= this.energyRange) continue;
                this.searchY = -this.energyRange;
            }
            if (this.energy <= 0) {
                return;
            }
            int toTransfer = Math.min(this.energyTransferLimit, this.energy);
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            for (BlockPos blockPos : this.portalBlocks) {
                BlockEntity entity = this.level.getBlockEntity(blockPos);
                if (entity instanceof IPortalGroupEntity && ((IPortalGroupEntity)entity).hasGroup()) {
                    PortalGroup group = ((IPortalGroupEntity)entity).getGroup();
                    int transferred = group.receiveEnergy(toTransfer, false);
                    toTransfer -= transferred;
                    this.energy -= transferred;
                    this.dataChanged();
                    if (this.energy != 0) continue;
                    return;
                }
                toRemove.add(blockPos);
            }
            if (!toRemove.isEmpty()) {
                this.portalBlocks.removeAll(toRemove);
                toRemove.clear();
                this.dataChanged();
            }
            for (Map.Entry entry : this.energyBlocks.entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                IEnergyStorage storage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)((Direction)entry.getValue()));
                if (storage != null && storage.canReceive()) {
                    int max = toTransfer;
                    int transferred = storage.receiveEnergy(max, false);
                    toTransfer -= transferred;
                    this.energy -= transferred;
                    this.dataChanged();
                    if (this.energy != 0) continue;
                    return;
                }
                toRemove.add(pos);
            }
            if (!toRemove.isEmpty()) {
                toRemove.forEach(this.energyBlocks::remove);
                this.dataChanged();
            }
        }
    }

    public Set<BlockPos> getChargingPortalBlocks() {
        return this.portalBlocks;
    }

    public Set<BlockPos> getChargingEnergyBlocks() {
        return this.energyBlocks.keySet();
    }

    protected CompoundTag writeData() {
        CompoundTag data = new CompoundTag();
        data.putInt("energy", this.energy);
        BlockPos self = this.worldPosition;
        data.putInt("searchX", this.searchX - self.getX());
        data.putInt("searchY", this.searchY - self.getY());
        data.putInt("searchZ", this.searchZ - self.getZ());
        data.putLongArray("portalBlocks", this.portalBlocks.stream().map(pos -> pos.subtract((Vec3i)self)).map(BlockPos::asLong).collect(Collectors.toList()));
        int[] energyBlocks = new int[this.energyBlocks.size() * 4];
        int index = 0;
        for (Map.Entry<BlockPos, Direction> entry : this.energyBlocks.entrySet()) {
            energyBlocks[index++] = entry.getKey().getX() - self.getX();
            energyBlocks[index++] = entry.getKey().getY() - self.getY();
            energyBlocks[index++] = entry.getKey().getZ() - self.getZ();
            energyBlocks[index++] = entry.getValue().get3DDataValue();
        }
        data.putIntArray("energyBlocks", energyBlocks);
        return data;
    }

    protected CompoundTag writeItemStackData() {
        CompoundTag data = super.writeItemStackData();
        data.remove("searchX");
        data.remove("searchY");
        data.remove("searchZ");
        data.remove("portalBlocks");
        data.remove("energyBlocks");
        return data;
    }

    protected void readData(CompoundTag tag) {
        this.energy = tag.contains("energy") ? tag.getInt("energy") : 0;
        BlockPos self = this.worldPosition;
        this.searchX = tag.contains("searchX") ? Math.min(Math.max(tag.getInt("searchX") + self.getX(), -this.energyRange), this.energyRange) : 0;
        this.searchY = tag.contains("searchY") ? Math.min(Math.max(tag.getInt("searchY") + self.getY(), -this.energyRange), this.energyRange) : 0;
        this.searchZ = tag.contains("searchZ") ? Math.min(Math.max(tag.getInt("searchZ") + self.getZ(), -this.energyRange), this.energyRange) : 0;
        this.portalBlocks.clear();
        if (tag.contains("portalBlocks", 12)) {
            Arrays.stream(tag.getLongArray("portalBlocks")).mapToObj(BlockPos::of).map(pos -> pos.offset((Vec3i)self)).forEach(this.portalBlocks::add);
        }
        this.energyBlocks.clear();
        if (tag.contains("energyBlocks", 11)) {
            int[] energyBlocks = tag.getIntArray("energyBlocks");
            int i = 0;
            while (i < energyBlocks.length / 4 * 4) {
                this.energyBlocks.put(new BlockPos(energyBlocks[i++] + self.getX(), energyBlocks[i++] + self.getY(), energyBlocks[i++] + self.getZ()), Direction.from3DDataValue((int)energyBlocks[i++]));
            }
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = Math.min(Math.min(this.energy, this.energyTransferLimit), maxExtract);
        if (extracted > 0 && !simulate) {
            this.energy -= extracted;
            this.dataChanged();
        }
        return Math.max(extracted, 0);
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.energyCapacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

