/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.generator.CoalGeneratorBlock;
import com.supermartijn642.wormhole.generator.GeneratorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CoalGeneratorBlockEntity
extends GeneratorBlockEntity
implements IItemHandlerModifiable {
    private int burnTime = 0;
    private int totalBurnTime = 0;
    private ItemStack stack = ItemStack.EMPTY;

    public CoalGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(Wormhole.coal_generator_tile, pos, state, WormholeConfig.coalGeneratorCapacity.get(), WormholeConfig.coalGeneratorRange.get(), WormholeConfig.coalGeneratorPower.get() * 2);
    }

    @Override
    public void update() {
        super.update();
        if (this.energy < this.energyCapacity) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.energy += WormholeConfig.coalGeneratorPower.get().intValue();
                if (this.energy > this.energyCapacity) {
                    this.energy = this.energyCapacity;
                }
                if (this.burnTime == 0) {
                    this.totalBurnTime = 0;
                    this.burnItem();
                }
                this.dataChanged();
            } else {
                this.burnItem();
            }
        }
    }

    private void burnItem() {
        int burnTime;
        int n = burnTime = this.stack.isEmpty() ? 0 : this.stack.getBurnTime(RecipeType.SMELTING);
        if (burnTime > 0) {
            this.burnTime = this.totalBurnTime = burnTime;
            if (this.stack.getCount() == 1) {
                ItemStack remainder = this.stack.getCraftingRemainingItem();
                this.stack = remainder == null ? ItemStack.EMPTY : remainder;
            } else {
                this.stack.shrink(1);
            }
            this.dataChanged();
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        boolean lit = (Boolean)this.getBlockState().getValue((Property)CoalGeneratorBlock.LIT);
        if (lit != this.burnTime > 0) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)CoalGeneratorBlock.LIT, (Comparable)Boolean.valueOf(!lit)));
        }
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag data = super.writeData();
        data.putInt("burnTime", this.burnTime);
        data.putInt("totalBurnTime", this.totalBurnTime);
        data.put("stack", this.stack.saveOptional((HolderLookup.Provider)this.level.registryAccess()));
        return data;
    }

    @Override
    protected void readData(CompoundTag tag) {
        super.readData(tag);
        this.burnTime = tag.contains("burnTime") ? tag.getInt("burnTime") : 0;
        this.totalBurnTime = tag.contains("totalBurnTime") ? tag.getInt("totalBurnTime") : 0;
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)CommonUtils.getRegistryAccess(), (CompoundTag)tag.getCompound("stack"));
    }

    public float getProgress() {
        return this.totalBurnTime == 0 ? 0.0f : (float)this.burnTime / (float)this.totalBurnTime;
    }

    public int getSlots() {
        return 1;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            this.stack = stack.copy();
        }
    }

    public ItemStack getStackInSlot(int slot) {
        return this.stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty() || !this.stack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack)) {
            return stack;
        }
        int count = Math.min(stack.getMaxStackSize() - this.stack.getCount(), stack.getCount());
        if (!simulate) {
            ItemStack newStack = stack.copy();
            newStack.setCount(this.stack.getCount() + count);
            this.stack = newStack;
        }
        ItemStack result = stack.copy();
        result.shrink(count);
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return this.stack.isEmpty() ? 64 : this.stack.getMaxStackSize();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Math.floor((double)stack.getBurnTime(RecipeType.SMELTING) / 2.5) > 0.0;
    }
}

