/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.generator.CoalGeneratorContainer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoalGeneratorBlock
extends BaseBlock
implements EntityHoldingBlock {
    private static final BlockShape SHAPE = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)12.0, (double)13.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)3.0, (double)0.0, (double)13.0, (double)7.0, (double)7.0, (double)15.0), BlockShape.createBlockShape((double)4.0, (double)7.0, (double)13.0, (double)6.0, (double)10.0, (double)14.0), BlockShape.createBlockShape((double)9.0, (double)0.0, (double)13.0, (double)13.0, (double)7.0, (double)15.0), BlockShape.createBlockShape((double)10.0, (double)7.0, (double)13.0, (double)12.0, (double)10.0, (double)14.0)});
    private static final BlockShape[] SHAPES = new BlockShape[4];
    public static final BooleanProperty LIT;
    public static final EnumProperty<Direction> FACING;

    public CoalGeneratorBlock() {
        super(true, BlockProperties.create().mapColor(MapColor.COLOR_GRAY).sound(SoundType.METAL).requiresCorrectTool().destroyTime(1.2f).explosionResistance(6.0f));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (!level.isClientSide) {
            CommonUtils.openContainer((BaseContainer)new CoalGeneratorContainer(player, pos));
        }
        return BaseBlock.InteractionFeedback.CONSUME;
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        int range = 2 * WormholeConfig.coalGeneratorRange.get() + 1;
        info.accept((Component)TextComponents.translation((String)"wormhole.coal_generator.info", (Object[])new Object[]{range, EnergyFormat.formatEnergyPerTick((int)WormholeConfig.coalGeneratorPower.get())}).color(ChatFormatting.AQUA).get());
        CompoundTag tag = (CompoundTag)stack.get(BaseBlock.TILE_DATA);
        int energy = tag == null || tag.isEmpty() || !tag.contains("energy", 3) ? 0 : tag.getInt("energy");
        info.accept((Component)TextComponents.string((String)EnergyFormat.formatCapacityWithUnit((int)energy, (int)WormholeConfig.coalGeneratorCapacity.get())).color(ChatFormatting.YELLOW).get());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue(FACING)).get2DDataValue()].getUnderlying();
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? 8 : 0;
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return Wormhole.coal_generator_tile.create(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, FACING});
    }

    static {
        CoalGeneratorBlock.SHAPES[Direction.NORTH.get2DDataValue()] = SHAPE;
        CoalGeneratorBlock.SHAPES[Direction.EAST.get2DDataValue()] = SHAPE.rotate(Direction.Axis.Y);
        CoalGeneratorBlock.SHAPES[Direction.SOUTH.get2DDataValue()] = SHAPE.rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        CoalGeneratorBlock.SHAPES[Direction.WEST.get2DDataValue()] = SHAPE.rotate(Direction.Axis.Y).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        LIT = BlockStateProperties.LIT;
        FACING = BlockStateProperties.HORIZONTAL_FACING;
    }
}

