/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellType;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class EnergyCellBlock
extends PortalGroupBlock {
    public static final IntegerProperty ENERGY_LEVEL = IntegerProperty.create((String)"energy_level", (int)0, (int)15);
    private final EnergyCellType type;

    public EnergyCellBlock(EnergyCellType type) {
        super(type::getBlockEntityType);
        this.type = type;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ENERGY_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"wormhole.energy_cell.info").color(ChatFormatting.AQUA).get());
        CompoundTag tag = (CompoundTag)stack.get(BaseBlock.TILE_DATA);
        int energy = this.type == EnergyCellType.CREATIVE ? this.type.getCapacity() : (tag == null || tag.isEmpty() || !tag.contains("energy") ? 0 : tag.getInt("energy"));
        int capacity = this.type.getCapacity();
        if (capacity > 0) {
            info.accept((Component)TextComponents.string((String)EnergyFormat.formatCapacityWithUnit((int)energy, (int)capacity)).color(ChatFormatting.YELLOW).get());
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ENERGY_LEVEL});
    }
}

