/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.WidgetContainerScreen;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.generator.CoalGeneratorScreen;
import com.supermartijn642.wormhole.generator.GeneratorBlockEntity;
import com.supermartijn642.wormhole.portal.screen.PortalOverviewScreen;
import com.supermartijn642.wormhole.portal.screen.PortalTargetColorScreen;
import com.supermartijn642.wormhole.portal.screen.PortalTargetScreen;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.common.NeoForge;

public class WormholeClient {
    public static void register() {
        NeoForge.EVENT_BUS.addListener(WormholeClient::onBlockHighlight);
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"wormhole");
        handler.registerBlockModelTranslucentRenderType(() -> Wormhole.portal);
        handler.registerContainerScreen(() -> Wormhole.coal_generator_container, container -> WidgetContainerScreen.of((Widget)new CoalGeneratorScreen(), (BaseContainer)container, (boolean)true));
    }

    public static void openTargetDeviceScreen(InteractionHand hand, BlockPos pos, float yaw) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new TargetDeviceScreen(hand, pos, yaw)));
    }

    public static void openPortalTargetScreen(BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new PortalTargetScreen(pos)));
    }

    public static void openPortalTargetScreen(BlockPos pos, int scrollOffset, int selectedPortalTarget, int selectedDeviceTarget) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new PortalTargetScreen(pos, scrollOffset, selectedPortalTarget, selectedDeviceTarget)));
    }

    public static void openPortalTargetColorScreen(BlockPos pos, int targetIndex, Runnable returnScreen) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new PortalTargetColorScreen(pos, targetIndex, returnScreen)));
    }

    public static void openPortalOverviewScreen(BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new PortalOverviewScreen(pos)));
    }

    public static void onBlockHighlight(RenderHighlightEvent.Block e) {
        Level level = ClientUtils.getWorld();
        BlockEntity entity = level.getBlockEntity(e.getTarget().getBlockPos());
        if (entity instanceof GeneratorBlockEntity) {
            VoxelShape shape;
            PoseStack poseStack = e.getPoseStack();
            poseStack.pushPose();
            Vec3 playerPos = RenderUtils.getCameraPosition();
            poseStack.translate(-playerPos.x, -playerPos.y, -playerPos.z);
            for (BlockPos pos : ((GeneratorBlockEntity)entity).getChargingPortalBlocks()) {
                shape = level.getBlockState(pos).getBlockSupportShape((BlockGetter)level, pos).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                RenderUtils.renderShape((PoseStack)poseStack, (VoxelShape)shape, (float)0.25882354f, (float)0.42352942f, (float)0.9607843f, (boolean)true);
            }
            for (BlockPos pos : ((GeneratorBlockEntity)entity).getChargingEnergyBlocks()) {
                shape = level.getBlockState(pos).getBlockSupportShape((BlockGetter)level, pos).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                RenderUtils.renderShape((PoseStack)poseStack, (VoxelShape)shape, (float)0.9490196f, (float)0.13333334f, (float)0.13333334f, (boolean)true);
            }
            poseStack.popPose();
        }
    }
}

