/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.wormhole.PortalBlockEntity;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PortalBlock
extends PortalGroupBlock
implements SimpleWaterloggedBlock {
    private static final BlockShape SHAPE_X = BlockShape.createBlockShape((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final BlockShape SHAPE_Y = BlockShape.createBlockShape((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final BlockShape SHAPE_Z = BlockShape.createBlockShape((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public static final EnumProperty<Direction.Axis> AXIS_PROPERTY = EnumProperty.create((String)"axis", Direction.Axis.class, (Enum[])Direction.Axis.values());
    public static final EnumProperty<DyeColor> COLOR_PROPERTY = EnumProperty.create((String)"color", DyeColor.class, (Enum[])DyeColor.values());
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public PortalBlock() {
        super(BlockProperties.create().noCollision().destroyTime(-1.0f).explosionResistance(-1.0f).sound(SoundType.GLASS).lightLevel(o -> 11).noLootTable(), () -> Wormhole.portal_tile);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS_PROPERTY, (Comparable)Direction.Axis.X)).setValue(COLOR_PROPERTY, (Comparable)DyeColor.WHITE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof PortalBlockEntity) {
            return ((PortalBlockEntity)entity).activate(player, hand) ? BaseBlock.InteractionFeedback.SUCCESS : BaseBlock.InteractionFeedback.PASS;
        }
        return super.interact(state, level, pos, player, hand, hitSide, hitLocation);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PortalBlockEntity) {
            ((PortalBlockEntity)blockEntity).teleport(entity);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS_PROPERTY, COLOR_PROPERTY, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS_PROPERTY);
        return (axis == Direction.Axis.X ? SHAPE_X : (axis == Direction.Axis.Y ? SHAPE_Y : (axis == Direction.Axis.Z ? SHAPE_Z : BlockShape.empty()))).getUnderlying();
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof PortalBlockEntity && !((PortalBlockEntity)entity).hasGroup()) {
            entity.getLevel().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ItemStack.EMPTY;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighbor, level, pos, neighborPos);
    }

    public boolean isPathfindable(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && level.getFluidState(pos).is(FluidTags.WATER);
    }
}

