/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.block.Block;

public class NBTRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<NBTRecipe> SERIALIZER = new Serializer();
    private static final List<Item> VALID_ITEMS = new LinkedList<Item>();
    private final String group;
    private final CraftingBookCategory category;
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final boolean showNotification;

    public NBTRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack recipeOutput, boolean showNotification) {
        super(group, category, pattern, recipeOutput, showNotification);
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = recipeOutput;
        this.showNotification = showNotification;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack result = this.getResultItem(provider).copy();
        block0: for (int i = 0; i < input.height(); ++i) {
            for (int j = 0; j < input.width(); ++j) {
                ItemStack stack = input.getItem(i * input.width() + j);
                if (!VALID_ITEMS.contains(stack.getItem())) continue;
                if (stack.has(BaseBlock.TILE_DATA)) {
                    result.set(BaseBlock.TILE_DATA, (Object)((CompoundTag)stack.get(BaseBlock.TILE_DATA)));
                    break block0;
                }
                if (!stack.has(TargetDeviceItem.TARGETS)) continue;
                result.set(TargetDeviceItem.TARGETS, (Object)((List)stack.get(TargetDeviceItem.TARGETS)));
                break block0;
            }
        }
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return super.getSerializer();
    }

    static {
        VALID_ITEMS.add((Item)Wormhole.target_device);
        VALID_ITEMS.add((Item)Wormhole.advanced_target_device);
        VALID_ITEMS.add(Item.byBlock((Block)Wormhole.portal_stabilizer));
        VALID_ITEMS.add(Item.byBlock((Block)Wormhole.basic_energy_cell));
        VALID_ITEMS.add(Item.byBlock((Block)Wormhole.advanced_energy_cell));
        VALID_ITEMS.add(Item.byBlock((Block)Wormhole.basic_target_cell));
        VALID_ITEMS.add(Item.byBlock((Block)Wormhole.advanced_target_cell));
        VALID_ITEMS.add(Item.byBlock((Block)Wormhole.coal_generator));
    }

    private static class Serializer
    implements RecipeSerializer<NBTRecipe> {
        private static final MapCodec<NBTRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, NBTRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, NBTRecipe> STREAM_CODEC = ShapedRecipe.Serializer.STREAM_CODEC.map(Serializer::fromShapedRecipe, Function.identity());

        private Serializer() {
        }

        public MapCodec<NBTRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, NBTRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static NBTRecipe fromShapedRecipe(ShapedRecipe recipe) {
            return new NBTRecipe(recipe.getGroup(), recipe.category(), recipe.pattern, recipe.getResultItem(null), recipe.showNotification());
        }
    }
}

