/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.blocks.LightType;

public class EntityBlockingLightBlock
extends Block {
    private final LightType lightType;

    public EntityBlockingLightBlock(BlockBehaviour.Properties properties, LightType lightType) {
        super(properties);
        this.lightType = lightType;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        return this.lightType.Shape;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        double d0 = (double)pos.getX() + this.lightType.FlameOffset.x;
        double d1 = (double)pos.getY() + this.lightType.FlameOffset.y;
        double d2 = (double)pos.getZ() + this.lightType.FlameOffset.z;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(state, level, pos, oldState, moving);
        Torchmaster.getRegistryForLevel(level).ifPresent(reg -> reg.registerLight(this.lightType.KeyFactory.apply(pos), this.lightType.LightFactory.apply(pos)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        Torchmaster.getRegistryForLevel(level).ifPresent(reg -> reg.unregisterLight(this.lightType.KeyFactory.apply(pos)));
        super.onRemove(state, level, pos, oldState, moving);
    }
}

