/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.PoweredCentrifugeBlockEntity;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.util.FluidContainerUtil;
import cy.jdkdigital.productivelib.client.screen.AbstractUpgradeableContainerScreen;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.fluids.FluidStack;

public class CentrifugeScreen<T extends CentrifugeContainer<? extends CentrifugeBlockEntity>>
extends AbstractUpgradeableContainerScreen<T> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/centrifuge.png");
    private static final ResourceLocation GUI_TEXTURE_POWERED = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/powered_centrifuge.png");
    private static final ResourceLocation GUI_TEXTURE_HEATED = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/heated_centrifuge.png");

    public CentrifugeScreen(T container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
    }

    public void render(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ICapabilityBlockEntity iCapabilityBlockEntity;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        FluidStack fluidStack = ((CentrifugeBlockEntity)((CentrifugeContainer)this.menu).getBlockEntity()).getFluidHandler().getFluidInTank(0);
        if (this.isHovering(140, 16, 6, 54, mouseX, mouseY)) {
            ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
            if (fluidStack.getAmount() > 0) {
                tooltipList.add(Component.translatable((String)"productivebees.screen.fluid_level", (Object[])new Object[]{fluidStack.getHoverName().getString(), fluidStack.getAmount() + "mB"}).getVisualOrderText());
            } else {
                tooltipList.add(Component.translatable((String)"productivebees.hive.tooltip.empty").getVisualOrderText());
            }
            guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
        if ((iCapabilityBlockEntity = ((CentrifugeContainer)this.menu).getBlockEntity()) instanceof PoweredCentrifugeBlockEntity) {
            PoweredCentrifugeBlockEntity poweredCentrifugeBlockEntity = (PoweredCentrifugeBlockEntity)iCapabilityBlockEntity;
            int energyAmount = poweredCentrifugeBlockEntity.energyHandler.getEnergyStored();
            if (this.isHovering(-5, 16, 6, 54, mouseX, mouseY)) {
                ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
                tooltipList.add(Component.translatable((String)"productivebees.screen.energy_level", (Object[])new Object[]{energyAmount + "FE"}).getVisualOrderText());
                guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
            }
        }
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        ICapabilityBlockEntity processingTime2;
        ResourceLocation GUI = ((CentrifugeContainer)this.menu).getBlockEntity() instanceof PoweredCentrifugeBlockEntity ? GUI_TEXTURE_POWERED : GUI_TEXTURE;
        guiGraphics.blit(GUI, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        ICapabilityBlockEntity iCapabilityBlockEntity = ((CentrifugeContainer)this.menu).getBlockEntity();
        if (iCapabilityBlockEntity instanceof CentrifugeBlockEntity) {
            CentrifugeBlockEntity centrifugeBlockEntity = (CentrifugeBlockEntity)iCapabilityBlockEntity;
            if (centrifugeBlockEntity.recipeProgress > 0) {
                int processingTime2 = centrifugeBlockEntity.getProcessingTime(centrifugeBlockEntity.getCurrentRecipe());
                int progress = (int)((float)(processingTime2 - centrifugeBlockEntity.recipeProgress) * (24.0f / (float)processingTime2));
                guiGraphics.blit(GUI, this.getGuiLeft() + 48, this.getGuiTop() + 35, 202, 52, progress + 1, 16);
            }
        }
        if ((processingTime2 = ((CentrifugeContainer)this.menu).getBlockEntity()) instanceof PoweredCentrifugeBlockEntity) {
            PoweredCentrifugeBlockEntity poweredCentrifugeBlockEntity = (PoweredCentrifugeBlockEntity)processingTime2;
            guiGraphics.blit(GUI, this.getGuiLeft() + 8, this.getGuiTop() + 17, 206, 0, 4, 52);
            int energyAmount = poweredCentrifugeBlockEntity.energyHandler.getEnergyStored();
            int energyLevel = (int)((float)energyAmount * 0.0052f);
            guiGraphics.blit(GUI, this.getGuiLeft() + 8, this.getGuiTop() + 17, 8, 17, 4, 52 - energyLevel);
        }
        if ((fluidStack = ((CentrifugeBlockEntity)((CentrifugeContainer)this.menu).getBlockEntity()).getFluidHandler().getFluidInTank(0)).getAmount() > 0) {
            FluidContainerUtil.renderFluidTank(guiGraphics, this, fluidStack, ((CentrifugeBlockEntity)((CentrifugeContainer)this.menu).getBlockEntity()).getFluidHandler().getTankCapacity(0), 140, 17, 4, 52, 0);
        }
    }
}

