/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class FeederContainer
extends AbstractContainer<FeederBlockEntity> {
    public FeederContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, FeederContainer.getTileEntity(playerInventory, data));
    }

    public FeederContainer(int windowId, Inventory playerInventory, FeederBlockEntity blockEntity) {
        super((MenuType)ModContainerTypes.FEEDER.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        IItemHandler inv = (IItemHandler)((FeederBlockEntity)this.getBlockEntity()).getLevel().getCapability(Capabilities.ItemHandler.BLOCK, ((FeederBlockEntity)this.getBlockEntity()).getBlockPos(), null);
        if (inv instanceof IItemHandler) {
            IItemHandler itemHandler = inv;
            this.addSlotBox(itemHandler, 0, 62, blockEntity.isDouble() ? 26 : 35, 3, 18, blockEntity.isDouble() ? 2 : 1, 18);
        }
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static FeederBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof FeederBlockEntity) {
            return (FeederBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

