/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.harvest;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.entity.bee.hive.FarmerBee;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;

public class MinecraftHarvester {
    public static boolean isCropValid(Level level, BlockPos pos) {
        if (pos == null) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof CocoaBlock && (Integer)state.getValue((Property)CocoaBlock.AGE) == 2) {
            return true;
        }
        if (state.hasProperty((Property)SweetBerryBushBlock.AGE) && (Integer)state.getValue((Property)SweetBerryBushBlock.AGE) == 3) {
            return true;
        }
        if (block instanceof AttachedStemBlock) {
            return true;
        }
        if (block instanceof CactusBlock || block instanceof SugarCaneBlock) {
            return level.getBlockState(pos.below()).getBlock().equals(state.getBlock());
        }
        return block instanceof CropBlock && !((CropBlock)block).isValidBonemealTarget((LevelReader)level, pos, state);
    }

    public static void harvestBlock(Level level, BlockPos pos) {
        BlockState cropBlockState = level.getBlockState(pos);
        Block cropBlock = cropBlockState.getBlock();
        if (cropBlock instanceof AttachedStemBlock) {
            AttachedStemBlock stemBlock = (AttachedStemBlock)cropBlock;
            BlockState fruitBlock = level.getBlockState(pos.relative((Direction)cropBlockState.getValue((Property)HorizontalDirectionalBlock.FACING)));
            if (fruitBlock.is(stemBlock.fruit)) {
                level.destroyBlock(pos.relative((Direction)cropBlockState.getValue((Property)HorizontalDirectionalBlock.FACING)), true);
            }
        } else if (cropBlock instanceof SugarCaneBlock || cropBlock instanceof CactusBlock) {
            int i = 0;
            while (i++ < 5 && level.getBlockState(pos.below()).getBlock().equals(cropBlock)) {
                pos = pos.below();
            }
            level.destroyBlock(pos.above(), true);
        } else if (cropBlock instanceof SweetBerryBushBlock) {
            int i = (Integer)cropBlockState.getValue((Property)SweetBerryBushBlock.AGE);
            if (i > 1) {
                int j = 1 + level.random.nextInt(2);
                ItemStack dropStack = cropBlock.getCloneItemStack((LevelReader)level, pos, cropBlockState);
                dropStack.setCount(j + (i == 3 ? 1 : 0));
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)dropStack);
                level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                level.setBlock(pos, (BlockState)cropBlockState.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1)), 2);
            }
        } else if (((Boolean)ProductiveBeesConfig.GENERAL.forceEnableFarmerBeeRightClickHarvest.get()).booleanValue() || ModList.get().isLoaded("right_click_get_crops") || ModList.get().isLoaded("croptopia") || ModList.get().isLoaded("quark") || ModList.get().isLoaded("harvest") || ModList.get().isLoaded("simplefarming") || ModList.get().isLoaded("pamhc2trees") || ModList.get().isLoaded("reap")) {
            FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)new GameProfile(FarmerBee.FARMER_BEE_UUID, "farmer_bee"));
            CommonHooks.onRightClickBlock((Player)fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)new BlockHitResult(Vec3.ZERO, Direction.DOWN, pos, true));
        } else {
            level.destroyBlock(pos, true);
        }
    }
}

