/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;

public class ItemConversionRecipe
implements Recipe<RecipeInput> {
    public final List<Supplier<BeeIngredient>> bees;
    public Ingredient ingredient;
    public ItemStack output;
    public final float chance;
    public final boolean pollinates;

    public ItemConversionRecipe(List<Supplier<BeeIngredient>> bees, Ingredient ingredient, ItemStack output, float chance, boolean pollinates) {
        this.bees = bees;
        this.ingredient = ingredient;
        this.output = output;
        this.chance = chance;
        this.pollinates = pollinates;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        if (inv instanceof BeeHelper.ItemInventory && this.bees.size() > 0) {
            String beeName = ((BeeHelper.ItemInventory)inv).getIdentifier(0);
            ItemStack inputItem = ((BeeHelper.ItemInventory)inv).getInput();
            boolean matchesInput = this.ingredient.test(inputItem);
            boolean matchesBee = false;
            for (Supplier<BeeIngredient> bee : this.bees) {
                matchesBee = matchesBee || bee.get().getBeeType().toString().equals(beeName);
            }
            return matchesBee && matchesInput;
        }
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public List<BeeIngredient> getBees() {
        ArrayList<BeeIngredient> list = new ArrayList<BeeIngredient>();
        this.bees.forEach(bee -> list.add((BeeIngredient)bee.get()));
        return list;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.ITEM_CONVERSION.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.ITEM_CONVERSION_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ItemConversionRecipe> {
        private static final MapCodec<ItemConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BeeIngredient.LIST_CODEC.fieldOf("bees").forGetter(recipe -> recipe.bees), (App)Ingredient.CODEC.fieldOf("ingredients").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.chance)), (App)Codec.BOOL.fieldOf("pollinates").orElse((Object)false).forGetter(recipe -> recipe.pollinates)).apply((Applicative)builder, ItemConversionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemConversionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ItemConversionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemConversionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ItemConversionRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                int beeCount = buffer.readInt();
                ArrayList<Supplier<BeeIngredient>> bees = new ArrayList<Supplier<BeeIngredient>>();
                for (int i = 0; i < beeCount; ++i) {
                    BeeIngredient source = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                    bees.add((Supplier<BeeIngredient>)Lazy.of(() -> source));
                }
                return new ItemConversionRecipe(bees, (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readFloat(), buffer.readBoolean());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading item conversion recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, ItemConversionRecipe recipe) {
            try {
                buffer.writeInt(recipe.bees.size());
                recipe.bees.forEach(bee -> ((BeeIngredient)bee.get()).toNetwork((FriendlyByteBuf)buffer));
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
                buffer.writeFloat(recipe.chance);
                buffer.writeBoolean(recipe.pollinates);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing item conversion recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

