/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity;

import cy.jdkdigital.productivebees.common.item.BeeBomb;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class BeeBombEntity
extends ThrowableItemProjectile {
    public BeeBombEntity(EntityType<? extends ThrowableItemProjectile> entity, Level world) {
        super(entity, world);
    }

    public BeeBombEntity(Level world, LivingEntity entity) {
        super((EntityType)ModEntities.BEE_BOMB.get(), entity, world);
    }

    @Nonnull
    protected Item getDefaultItem() {
        return (Item)ModItems.BEE_BOMB.get();
    }

    protected void onHit(@Nonnull HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            BeeBomb beeBomb;
            boolean isAngry;
            BlockPos blockPos = null;
            Entity entity = null;
            if (result.getType() == HitResult.Type.BLOCK) {
                blockPos = ((BlockHitResult)result).getBlockPos();
            } else if (result.getType() == HitResult.Type.ENTITY) {
                entity = ((EntityHitResult)result).getEntity();
                blockPos = entity.blockPosition();
            }
            ItemStack bomb = this.getItem();
            Item item = bomb.getItem();
            boolean bl = isAngry = item instanceof BeeBomb && (beeBomb = (BeeBomb)item).isAngry();
            if (blockPos != null) {
                List players;
                blockPos = blockPos.above();
                ListTag bees = BeeBomb.getBees(bomb);
                if (!(entity instanceof Player) && (players = this.level().getEntitiesOfClass(Player.class, new AABB(blockPos).inflate(5.0, 2.0, 5.0))).size() > 0) {
                    entity = (Entity)players.iterator().next();
                }
            }
            this.discard();
        }
    }
}

