/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.Arrays;
import net.mehvahdjukaar.amendments.common.CakeRegistry;
import net.mehvahdjukaar.amendments.common.block.DirectionalCakeBlock;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DoubleCakeBlock
extends DirectionalCakeBlock {
    protected static final VoxelShape[] SHAPES_NORTH = new VoxelShape[]{Shapes.or((VoxelShape)DoubleCakeBlock.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)DoubleCakeBlock.box((double)2.0, (double)8.0, (double)3.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)DoubleCakeBlock.box((double)2.0, (double)8.0, (double)5.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)DoubleCakeBlock.box((double)2.0, (double)8.0, (double)7.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)DoubleCakeBlock.box((double)2.0, (double)8.0, (double)9.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)DoubleCakeBlock.box((double)2.0, (double)8.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)DoubleCakeBlock.box((double)2.0, (double)8.0, (double)13.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)DoubleCakeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0))};
    protected static final VoxelShape[] SHAPES_WEST = (VoxelShape[])Arrays.stream(SHAPES_NORTH).map(s -> MthUtils.rotateVoxelShape((VoxelShape)s, (Direction)Direction.WEST)).toArray(VoxelShape[]::new);
    protected static final VoxelShape[] SHAPES_SOUTH = (VoxelShape[])Arrays.stream(SHAPES_NORTH).map(s -> MthUtils.rotateVoxelShape((VoxelShape)s, (Direction)Direction.SOUTH)).toArray(VoxelShape[]::new);
    protected static final VoxelShape[] SHAPES_EAST = (VoxelShape[])Arrays.stream(SHAPES_NORTH).map(s -> MthUtils.rotateVoxelShape((VoxelShape)s, (Direction)Direction.EAST)).toArray(VoxelShape[]::new);
    private final BlockState mimic;

    public DoubleCakeBlock(CakeRegistry.CakeType type) {
        super(type);
        this.mimic = type.cake.defaultBlockState();
    }

    public DoubleCakeBlock(BlockBehaviour.Properties properties, CakeRegistry.CakeType type) {
        super(properties, type);
        this.mimic = type.cake.defaultBlockState();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = stack.getItem();
        if (stack.is(ItemTags.CANDLES) && Block.byItem((Item)item) instanceof CandleBlock) {
            if (hitResult.getDirection() == Direction.UP) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> SHAPES_EAST[(Integer)state.getValue((Property)BITES)];
            case Direction.SOUTH -> SHAPES_SOUTH[(Integer)state.getValue((Property)BITES)];
            case Direction.NORTH -> SHAPES_NORTH[(Integer)state.getValue((Property)BITES)];
            default -> SHAPES_WEST[(Integer)state.getValue((Property)BITES)];
        };
    }

    @Override
    public void removeSlice(BlockState state, BlockPos pos, LevelAccessor level, Player player, Direction dir) {
        int i = (Integer)state.getValue((Property)BITES);
        if (i < 6) {
            if (i == 0 && CommonConfigs.DIRECTIONAL_CAKE.get().booleanValue()) {
                state = (BlockState)state.setValue((Property)FACING, (Comparable)dir);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else if (this.type == CakeRegistry.VANILLA && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && CommonConfigs.DIRECTIONAL_CAKE.get().booleanValue()) {
            level.setBlock(pos, (BlockState)((BlockState)ModRegistry.DIRECTIONAL_CAKE.get().defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED))), 3);
        } else {
            level.setBlock(pos, this.type.cake.defaultBlockState(), 3);
        }
    }

    @Override
    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.spawnCakeParticles(level, pos, rand);
        }
        super.animateTick(stateIn, level, pos, rand);
        this.mimic.getBlock().animateTick(this.mimic, level, pos, rand);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        return Math.min(super.getDestroyProgress(state, player, worldIn, pos), this.mimic.getDestroyProgress(player, worldIn, pos));
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        return this.mimic.getSoundType();
    }

    public SoundType getSoundType(BlockState state) {
        return this.mimic.getSoundType();
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        float f;
        if (level instanceof Level) {
            Level l = (Level)level;
            f = Math.max(ForgeHelper.getExplosionResistance((BlockState)this.mimic, (Level)l, (BlockPos)pos, (Explosion)explosion), state.getBlock().getExplosionResistance());
        } else {
            f = super.getExplosionResistance();
        }
        return f;
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.mimic.getBlock().getCloneItemStack(level, pos, state);
    }
}

