/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanical_cow.content;

import com.oierbravo.mechanical_cow.MechanicalCow;
import com.oierbravo.mechanical_cow.ModLang;
import com.oierbravo.mechanical_cow.content.MechanicalCowBlock;
import com.oierbravo.mechanical_cow.infrastructure.config.MConfigs;
import com.oierbravo.mechanical_cow.registrate.ModBlockEntities;
import com.oierbravo.mechanicals.compat.jade.IHavePercent;
import com.oierbravo.mechanicals.foundation.blockEntity.behaviour.DynamicCycleBehavior;
import com.oierbravo.mechanicals.utility.MechanicalConfigUtils;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MechanicalCowBlockEntity
extends KineticBlockEntity
implements DynamicCycleBehavior.DynamicCycleBehaviorSpecifics,
IHavePercent {
    private DynamicCycleBehavior cycleBehaviour;
    public SmartFluidTankBehaviour outputTank;
    private Ingredient requiredItemIngredient;
    private int requiredIngredientAmount;
    private FluidStack outputFluid;
    public final ItemStackHandler inputInventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MechanicalCowBlockEntity.this.setChanged();
            MechanicalCowBlockEntity.this.level.sendBlockUpdated(MechanicalCowBlockEntity.this.worldPosition, MechanicalCowBlockEntity.this.getBlockState(), MechanicalCowBlockEntity.this.getBlockState(), 3);
        }
    };
    private final Lazy<IItemHandler> itemCapability = Lazy.of(() -> this.inputInventory);

    public MechanicalCowBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.verifyConfig(MechanicalCow.LOGGER);
    }

    public int getProcessingTime() {
        return (Integer)MConfigs.server().mechanicalCow.processingTime.get();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.outputTank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)((Integer)MConfigs.server().mechanicalCow.fluidCapacity.get()));
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.cycleBehaviour = new DynamicCycleBehavior((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.cycleBehaviour);
    }

    public void remove() {
        super.remove();
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.MECHANICAL_COW.get(), (be, context) -> {
            Direction localDir = (Direction)be.getBlockState().getValue(MechanicalCowBlock.HORIZONTAL_FACING);
            if (context != null && localDir == context) {
                return be.getItemHandler();
            }
            if (context == null) {
                return be.getItemHandler();
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntities.MECHANICAL_COW.get(), (be, context) -> {
            Direction localDir = (Direction)be.getBlockState().getValue(MechanicalCowBlock.HORIZONTAL_FACING);
            if (context != null && localDir == context.getOpposite()) {
                return be.outputTank.getCapability();
            }
            if (context == null) {
                return be.outputTank.getCapability();
            }
            return null;
        });
    }

    @Nullable
    private IItemHandler getItemHandler() {
        return this.inputInventory;
    }

    public DynamicCycleBehavior getCycleBehaviour() {
        return this.cycleBehaviour;
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("InputInventory", (Tag)this.inputInventory.serializeNBT(registries));
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.inputInventory.deserializeNBT(registries, compound.getCompound("InputInventory"));
        super.read(compound, registries, clientPacket);
    }

    public float getKineticSpeed() {
        return this.getSpeed();
    }

    public boolean tryProcess(boolean simulate) {
        if (this.inputInventory.getStackInSlot(0).isEmpty()) {
            return false;
        }
        if (!this.requiredItemIngredient.test(this.inputInventory.getStackInSlot(0))) {
            return false;
        }
        int a = this.inputInventory.extractItem(0, this.requiredIngredientAmount, true).getCount();
        if (this.inputInventory.extractItem(0, this.requiredIngredientAmount, true).getCount() != this.requiredIngredientAmount) {
            return false;
        }
        if (this.outputTank.getPrimaryHandler().fill(this.outputFluid, IFluidHandler.FluidAction.SIMULATE) == 0) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.inputInventory.extractItem(0, this.requiredIngredientAmount, false);
        this.outputTank.getPrimaryHandler().fill(this.outputFluid, IFluidHandler.FluidAction.EXECUTE);
        return true;
    }

    public void playCompletionSound() {
        this.level.playSound((Entity)null, this.worldPosition, SoundEvents.COW_MILK, SoundSource.BLOCKS, ((Double)MConfigs.server().mechanicalCow.soundVolume.get()).floatValue(), 1.0f);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.cycleBehaviour.isRunning()) {
            ModLang.translate("mechanical_cow.tooltip.progress", this.getProgressPercent()).style(ChatFormatting.YELLOW).forGoggles(tooltip);
            added = true;
        }
        return added;
    }

    public int getProgressPercent() {
        return this.cycleBehaviour.getProgressPercent();
    }

    public void verifyConfig(Logger logger) {
        this.requiredIngredientAmount = (Integer)MConfigs.server().mechanicalCow.requiredIngredientAmount.get();
        if (this.requiredItemIngredient == null) {
            this.requiredItemIngredient = MechanicalConfigUtils.readIngredient((String)((String)MConfigs.server().mechanicalCow.requiredIngredient.get()), (TagKey)Tags.Items.CROPS_WHEAT);
        }
        if (this.outputFluid == null) {
            this.outputFluid = MechanicalConfigUtils.readFluidStack((String)((String)MConfigs.server().mechanicalCow.outputFluid.get()), (int)((Integer)MConfigs.server().mechanicalCow.outputAmount.get()), (String)"minecraft:milk");
        }
    }
}

