/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanical_cow.compat.jei;

import com.oierbravo.mechanical_cow.ModLang;
import com.oierbravo.mechanical_cow.compat.jei.AnimatedCow;
import com.oierbravo.mechanical_cow.infrastructure.config.MConfigs;
import com.oierbravo.mechanical_cow.registrate.ModBlocks;
import com.oierbravo.mechanicals.utility.MechanicalConfigUtils;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;

public class MechanicalCowCategory
implements IRecipeCategory<MechanicalCowRecipe> {
    public static final RecipeType<MechanicalCowRecipe> TYPE = RecipeType.create((String)"mechanical_cow", (String)"production", MechanicalCowRecipe.class);
    private final IDrawable icon;
    private final IDrawable slotDrawable;
    private AnimatedCow animatedCow = new AnimatedCow();

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 40;
    }

    public MechanicalCowCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModBlocks.MECHANICAL_COW));
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public RecipeType<MechanicalCowRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return ModLang.translate("recipe", new Object[0]).component();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MechanicalCowRecipe recipe, IFocusGroup iFocusGroup) {
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 4, 15).setBackground(this.slotDrawable, -1, -1);
        if (recipe.ingredient != null) {
            ((IRecipeSlotBuilder)input.addIngredients(recipe.ingredient)).setBackground(this.slotDrawable, -1, -1);
        }
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 155, 15);
        if (recipe.fluid != null) {
            output.addFluidStack(recipe.fluid().getFluid(), (long)recipe.fluid().getAmount()).addRichTooltipCallback(MechanicalCowCategory::addFluidAmountTooltip);
        }
    }

    private static void addFluidAmountTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
        Optional displayed = recipeSlotView.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK);
        if (displayed.isEmpty()) {
            return;
        }
        FluidStack fluidStack = (FluidStack)displayed.get();
        tooltip.add((FormattedText)Component.literal((String)(fluidStack.getAmount() + "mB")));
    }

    public void draw(MechanicalCowRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        AllGuiTextures.JEI_ARROW.render(guiGraphics, 30, 16);
        AllGuiTextures.JEI_ARROW.render(guiGraphics, 110, 16);
        this.animatedCow.draw(guiGraphics, 82, 35);
    }

    public static List<MechanicalCowRecipe> getRecipes() {
        ArrayList<MechanicalCowRecipe> recipes = new ArrayList<MechanicalCowRecipe>();
        recipes.add(new MechanicalCowRecipe(MechanicalConfigUtils.readIngredient((String)((String)MConfigs.server().mechanicalCow.requiredIngredient.get()), (TagKey)Tags.Items.CROPS_WHEAT), MechanicalConfigUtils.readFluidStack((String)((String)MConfigs.server().mechanicalCow.outputFluid.get()), (int)((Integer)MConfigs.server().mechanicalCow.outputAmount.get()), (String)"minecraft:milk")));
        return recipes;
    }

    public record MechanicalCowRecipe(Ingredient ingredient, FluidStack fluid) {
    }
}

