/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.ArrayList;
import java.util.List;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.util.GAGUtil;
import ky.someone.mods.gag.util.Tooltips;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class RepellingItem
extends GAGItem {
    public final int duration;
    public final int amplifier;
    private final boolean addExtraTooltip;

    public RepellingItem(Item.Properties properties, int duration, int amplifier, boolean addExtraTooltip) {
        super(properties);
        this.duration = duration;
        this.amplifier = amplifier;
        this.addExtraTooltip = addExtraTooltip;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        ArrayList<Component> infoTooltips = new ArrayList<Component>();
        infoTooltips.add((Component)Tooltips.MAIN.lang("info.gag.repelling_item", new Object[0]));
        if (this.addExtraTooltip) {
            infoTooltips.add((Component)Tooltips.EXTRA.lang(this.getDescriptionId() + ".extra", new Object[0]));
        }
        GAGUtil.appendInfoTooltip(tooltip, infoTooltips);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean hasEffect = player.hasEffect(GAGRegistry.REPELLING);
        ItemStack stack = player.getItemInHand(hand);
        if (!hasEffect) {
            level.playSound(null, player.blockPosition(), (SoundEvent)GAGRegistry.REPELLING_APPLY.value(), SoundSource.PLAYERS, 1.5f, 1.0f);
            player.addEffect(new MobEffectInstance(GAGRegistry.REPELLING, this.duration, this.amplifier));
            stack.shrink(1);
        }
        return hasEffect ? InteractionResultHolder.fail((Object)stack) : InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }
}

