/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.potionbundles;

import com.github.minecraftschurlimods.potionbundles.AbstractPotionBundle;
import com.github.minecraftschurlimods.potionbundles.PotionBundleString;
import com.github.minecraftschurlimods.potionbundles.PotionBundles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PotionBundleRecipe
extends CustomRecipe {
    private static final MapCodec<PotionBundleRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("string").forGetter(PotionBundleRecipe::getString), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("potion").forGetter(PotionBundleRecipe::getPotionItem), (App)BuiltInRegistries.ITEM.byNameCodec().comapFlatMap(bundle -> {
        DataResult dataResult;
        if (bundle instanceof AbstractPotionBundle) {
            AbstractPotionBundle bundle1 = (AbstractPotionBundle)((Object)((Object)bundle));
            dataResult = DataResult.success((Object)((Object)bundle1));
        } else {
            dataResult = DataResult.error(() -> "The defined PotionBundle is not an instance of AbstractPotionBundle");
        }
        return dataResult;
    }, Function.identity()).fieldOf("bundle").forGetter(PotionBundleRecipe::getBundleItem)).apply((Applicative)inst, PotionBundleRecipe::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, PotionBundleRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, PotionBundleRecipe::getString, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), PotionBundleRecipe::getPotionItem, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM).map(AbstractPotionBundle.class::cast, Function.identity()), PotionBundleRecipe::getBundleItem, PotionBundleRecipe::new);
    private final Ingredient string;
    private final Item potion;
    private final AbstractPotionBundle bundle;

    public PotionBundleRecipe(Ingredient string, Item potion, AbstractPotionBundle bundle) {
        super(CraftingBookCategory.EQUIPMENT);
        this.string = string;
        this.potion = potion;
        this.bundle = bundle;
    }

    public boolean matches(CraftingInput inv, Level world) {
        int potions = 0;
        boolean string = false;
        PotionContents potionContents = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack is = inv.getItem(i);
            if (this.string.test(is)) {
                if (string) {
                    return false;
                }
                string = true;
                continue;
            }
            if (is.getItem() == this.potion) {
                if (potions == 0) {
                    potionContents = (PotionContents)is.get(DataComponents.POTION_CONTENTS);
                    ++potions;
                } else if (potions > 0) {
                    if (!Objects.equals(potionContents, is.get(DataComponents.POTION_CONTENTS))) {
                        return false;
                    }
                    ++potions;
                }
                if (potions <= this.bundle.getMaxUses()) continue;
                return false;
            }
            if (is.isEmpty()) continue;
            return false;
        }
        return potions == this.bundle.getMaxUses() && string;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        PotionBundleString string = null;
        PotionContents potionContents = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack is = inv.getItem(i);
            if (potionContents == null && is.is(this.potion)) {
                potionContents = (PotionContents)is.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            }
            if (string == null && this.string.test(is)) {
                string = PotionBundleString.fromItemStack(is);
            }
            if (potionContents == null || string == null) continue;
            return this.bundle.createStack(string, potionContents);
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > this.bundle.getMaxUses();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)PotionBundles.POTION_BUNDLE_RECIPE_SERIALIZER.get();
    }

    public AbstractPotionBundle getBundleItem() {
        return this.bundle;
    }

    public Item getPotionItem() {
        return this.potion;
    }

    public Ingredient getString() {
        return this.string;
    }

    static class Serializer
    implements RecipeSerializer<PotionBundleRecipe> {
        Serializer() {
        }

        public MapCodec<PotionBundleRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotionBundleRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

