/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.potionbundles;

import com.github.minecraftschurlimods.potionbundles.AbstractPotionBundle;
import com.github.minecraftschurlimods.potionbundles.Config;
import com.github.minecraftschurlimods.potionbundles.PotionBundleUtils;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PotionBundle
extends AbstractPotionBundle {
    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).addPotionTooltip(tooltip::add, 1.0f, context.tickRate());
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        Player player;
        Player player2 = player = entity instanceof Player ? (Player)entity : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
        }
        if (!world.isClientSide) {
            PotionContents potioncontents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            potioncontents.forEachEffect(effectInstance -> {
                if (((MobEffect)effectInstance.getEffect().value()).isInstantenous()) {
                    ((MobEffect)effectInstance.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, entity, effectInstance.getAmplifier(), 1.0);
                } else {
                    entity.addEffect(effectInstance);
                }
            });
        }
        if (player == null || !player.hasInfiniteMaterials()) {
            PotionBundleUtils.decrementUses(stack);
            if (player != null) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
        }
        entity.gameEvent((Holder)GameEvent.DRINK);
        if (PotionBundleUtils.getUses(stack) != 0) {
            return stack;
        }
        if (((Boolean)Config.SERVER.returnString.get()).booleanValue()) {
            return PotionBundleUtils.getString(stack);
        }
        return ItemStack.EMPTY;
    }
}

