/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.potionbundles;

import com.github.minecraftschurlimods.potionbundles.AbstractPotionBundle;
import com.github.minecraftschurlimods.potionbundles.PotionBundleRecipe;
import com.github.minecraftschurlimods.potionbundles.PotionBundleUtils;
import com.github.minecraftschurlimods.potionbundles.PotionBundles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"potionbundles", (String)"potionbundles");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft minecraft = Objects.requireNonNull(Minecraft.getInstance());
        ClientLevel level = Objects.requireNonNull(minecraft.level);
        RecipeManager recipeManager = level.getRecipeManager();
        List recipes = recipeManager.getAllRecipesFor(RecipeType.CRAFTING).stream().map(RecipeHolder::value).filter(PotionBundleRecipe.class::isInstance).map(PotionBundleRecipe.class::cast).flatMap(recipe -> this.mapRecipes((PotionBundleRecipe)((Object)recipe), (HolderLookup.Provider)level.registryAccess())).toList();
        registration.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    private Stream<RecipeHolder<CraftingRecipe>> mapRecipes(PotionBundleRecipe recipe, HolderLookup.Provider registries) {
        String group = "jei.potionbundle";
        AbstractPotionBundle bundleItem = recipe.getBundleItem();
        int maxUses = bundleItem.getMaxUses();
        Item potionItem = recipe.getPotionItem();
        return registries.lookup(Registries.POTION).stream().flatMap(HolderLookup::listElements).map(potion -> {
            PotionContents potionContents = new PotionContents((Holder)potion);
            Ingredient potionIngredient = DataComponentIngredient.of((boolean)false, (DataComponentType)DataComponents.POTION_CONTENTS, (Object)potionContents, (ItemLike[])new ItemLike[]{potionItem});
            NonNullList inputs = NonNullList.withSize((int)(maxUses + 1), (Object)Ingredient.EMPTY);
            for (int i = 0; i < maxUses; ++i) {
                inputs.set(i, (Object)potionIngredient);
            }
            inputs.set(maxUses, (Object)recipe.getString());
            ItemStack output = PotionContents.createItemStack((Item)bundleItem, (Holder)potion);
            PotionBundleUtils.setUses(output, maxUses);
            ResourceLocation id = ResourceLocation.withDefaultNamespace((String)(group + "." + output.getDescriptionId() + "." + Potion.getName(Optional.of(potion), (String)"")));
            return new RecipeHolder(id, (Recipe)new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, output, inputs));
        });
    }

    public void registerItemSubtypes(ISubtypeRegistration r) {
        IIngredientSubtypeInterpreter byPotion = (ingredient, context) -> ((PotionContents)ingredient.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().map(Holder::getRegisteredName).orElse("unknown");
        r.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)PotionBundles.POTION_BUNDLE.get()), byPotion);
        r.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)PotionBundles.SPLASH_POTION_BUNDLE.get()), byPotion);
        r.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)PotionBundles.LINGERING_POTION_BUNDLE.get()), byPotion);
    }
}

