/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.potionbundles;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ModConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ModConfigSpec serverSpec;
    public static final Server SERVER;

    static {
        Pair clientPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
        Pair serverPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.IntValue durabilityBarColor;
        public final ModConfigSpec.BooleanValue showDurabilityBar;

        Client(ModConfigSpec.Builder builder) {
            this.durabilityBarColor = builder.comment("What color the damage bar of a potion bundle should have. Set to -1 to not display a damage bar.").translation("config.potionbundles.durabilityBarColor").defineInRange("durabilityBarColor", 221, -1, 0xFFFFFF);
            this.showDurabilityBar = builder.comment("Whether to show the durability bar of the potion bundles.").translation("config.potionbundles.showDurabilityBar").define("showDurabilityBar", false);
        }
    }

    public static class Server {
        public final ModConfigSpec.BooleanValue returnString;

        Server(ModConfigSpec.Builder builder) {
            this.returnString = builder.comment("Whether to return the string upon finishing the bundle or not.").translation("config.potionbundles.returnString").define("returnString", true);
        }
    }
}

