/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.potionbundles;

import com.github.minecraftschurlimods.potionbundles.PotionBundles;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="potionbundles")
public class ClientHandler {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> {
            ItemPropertyFunction propertyFunction = (stack, world, living, seed) -> ((Integer)stack.getOrDefault(PotionBundles.USES, (Object)0)).intValue();
            ResourceLocation uses = ResourceLocation.fromNamespaceAndPath((String)"potionbundles", (String)"uses");
            for (DeferredHolder item : PotionBundles.ITEMS.getEntries()) {
                ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)uses, (ItemPropertyFunction)propertyFunction);
            }
        });
    }

    @SubscribeEvent
    public static void registerItemColorHandler(RegisterColorHandlersEvent.Item e) {
        e.register((stack, index) -> index > 0 ? -1 : ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor(), (ItemLike[])PotionBundles.ITEMS.getEntries().stream().map(DeferredHolder::get).toArray(Item[]::new));
    }
}

