/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.potionbundles;

import com.github.minecraftschurlimods.potionbundles.AbstractPotionBundle;
import com.github.minecraftschurlimods.potionbundles.Config;
import com.github.minecraftschurlimods.potionbundles.PotionBundleUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class AbstractThrowablePotionBundle
extends AbstractPotionBundle {
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        this.playThrowSound(world, player);
        if (!world.isClientSide) {
            ThrownPotion thrownpotion = new ThrownPotion(world, (LivingEntity)player);
            ItemStack fake = new ItemStack((ItemLike)PotionBundleUtils.getPotionForBundle(this));
            fake.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)itemstack.get(DataComponents.POTION_CONTENTS)));
            thrownpotion.setItem(fake);
            thrownpotion.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            world.addFreshEntity((Entity)thrownpotion);
        }
        if (!player.hasInfiniteMaterials()) {
            PotionBundleUtils.decrementUses(itemstack);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (PotionBundleUtils.getUses(itemstack) != 0) {
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)world.isClientSide());
        }
        return InteractionResultHolder.sidedSuccess((Object)((Boolean)Config.SERVER.returnString.get() != false ? PotionBundleUtils.getString(itemstack) : ItemStack.EMPTY), (boolean)world.isClientSide());
    }

    protected abstract void playThrowSound(Level var1, Player var2);
}

