/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.potionbundles;

import com.github.minecraftschurlimods.potionbundles.Config;
import com.github.minecraftschurlimods.potionbundles.PotionBundleString;
import com.github.minecraftschurlimods.potionbundles.PotionBundleUtils;
import com.github.minecraftschurlimods.potionbundles.PotionBundles;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class AbstractPotionBundle
extends PotionItem {
    public AbstractPotionBundle() {
        super(new Item.Properties().stacksTo(1));
    }

    public ItemStack getDefaultInstance() {
        ItemStack itemstack = super.getDefaultInstance();
        itemstack.set(PotionBundles.USES, (Object)this.getMaxUses());
        return itemstack;
    }

    @VisibleForTesting
    public int getMaxUses() {
        return 3;
    }

    public int getBarWidth(ItemStack stack) {
        if ((Integer)Config.CLIENT.durabilityBarColor.get() == -1) {
            return 1;
        }
        return Math.round((float)PotionBundleUtils.getUses(stack) / (float)this.getMaxUses() * 13.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".uses"), (Object[])new Object[]{PotionBundleUtils.getUses(stack)}));
    }

    public int getBarColor(ItemStack stack) {
        return (Integer)Config.CLIENT.durabilityBarColor.get();
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Boolean)Config.CLIENT.showDurabilityBar.get();
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{PotionBundleUtils.getPotionForBundle(this).getName(stack)});
    }

    @VisibleForTesting
    public ItemStack createStack(@Nullable PotionBundleString string, Holder<Potion> potion, List<MobEffectInstance> customEffects, @Nullable Integer customColor) {
        return this.createStack(string, new PotionContents(Optional.of(potion), Optional.ofNullable(customColor), customEffects));
    }

    @VisibleForTesting
    public ItemStack createStack(@Nullable PotionBundleString string, PotionContents potionContents) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        PotionBundleUtils.setUses(stack, this.getMaxUses());
        PotionBundleUtils.setString(stack, string);
        return stack;
    }
}

