/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.hook;

import com.lance5057.butchercraft.ButchercraftBlockEntities;
import com.lance5057.butchercraft.ButchercraftRecipes;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.bases.recipes.RecipeMobEffect;
import com.lance5057.butchercraft.workstations.hook.HookRecipe;
import com.lance5057.butchercraft.workstations.hook.HookRecipeContainer;
import com.lance5057.butchercraft.workstations.hook.MeatHookBlock;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.ItemStackHandler;

public class MeatHookBlockEntity
extends BlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final Lazy<ItemStackHandler> itemHandler = Lazy.of(() -> this.inventory);
    public boolean recipeLocked = false;
    public int progress;
    public int maxProgress;
    private Ingredient curTool;
    public int toolCount;
    public int stage = 0;
    public boolean displayTools = true;

    public MeatHookBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ButchercraftBlockEntities.MEAT_HOOK.get(), pPos, pState);
    }

    public ItemStackHandler getHandler() {
        return (ItemStackHandler)this.itemHandler.get();
    }

    public void setRecipe(Optional<HookRecipe> r) {
        if (r.isPresent()) {
            this.setupStage(r.get(), 0);
        } else {
            this.zeroProgress();
        }
    }

    public void zeroProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.curTool = null;
        this.toolCount = 0;
        this.stage = 0;
    }

    public Optional<AnimatedRecipeItemUse> getCurrentTool() {
        return this.matchRecipe().map(hookRecipe -> (AnimatedRecipeItemUse)((HookRecipe)hookRecipe.value()).tools().get(this.stage));
    }

    protected void setupStage(HookRecipe r, int i) {
        this.progress = 0;
        this.maxProgress = ((AnimatedRecipeItemUse)r.tools().get(i)).uses();
        this.curTool = ((AnimatedRecipeItemUse)r.tools().get(i)).tool();
        this.toolCount = ((AnimatedRecipeItemUse)r.tools().get(i)).count();
        this.stage = i;
    }

    boolean isFinalStage(HookRecipe r) {
        int i = r.tools().size();
        return i - 1 <= this.stage;
    }

    private Optional<RecipeHolder<HookRecipe>> matchRecipe() {
        if (this.level != null) {
            return this.level.getRecipeManager().getRecipeFor((RecipeType)ButchercraftRecipes.HOOK.get(), (RecipeInput)new HookRecipeContainer(this.getInsertedItem()), this.level);
        }
        return Optional.empty();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                MeatHookBlockEntity.this.updateInventory();
                MeatHookBlockEntity.this.zeroProgress();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                boolean recipeWithInputExists = false;
                if (MeatHookBlockEntity.this.level != null) {
                    recipeWithInputExists = MeatHookBlockEntity.this.level.getRecipeManager().getRecipes().stream().filter(recipe -> recipe.value() instanceof HookRecipe).map(recipe -> (HookRecipe)recipe.value()).anyMatch(hookRecipe -> hookRecipe.carcass().test(stack));
                }
                return recipeWithInputExists && super.isItemValid(slot, stack);
            }
        };
    }

    public ItemStack getInsertedItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    public void extractItem(Player playerEntity) {
        if (!this.inventory.getStackInSlot(0).isEmpty()) {
            ItemStack itemStack = this.inventory.extractItem(0, this.inventory.getStackInSlot(0).getCount(), false);
            playerEntity.addItem(itemStack);
            Block block = this.level.getBlockState(this.worldPosition).getBlock();
            if (block instanceof MeatHookBlock) {
                MeatHookBlock m = (MeatHookBlock)block;
                m.removeBelow(this.level, this.worldPosition);
            }
        }
        this.updateInventory();
    }

    public void insertItem(ItemStack heldItem) {
        if (this.inventory.isItemValid(0, heldItem) && !ItemStack.isSameItemSameComponents((ItemStack)this.inventory.insertItem(0, heldItem, true), (ItemStack)heldItem)) {
            int leftover = this.inventory.insertItem(0, heldItem.copy(), false).getCount();
            heldItem.setCount(leftover);
            Block block = this.level.getBlockState(this.worldPosition).getBlock();
            if (block instanceof MeatHookBlock) {
                MeatHookBlock m = (MeatHookBlock)block;
                m.placeBelow(this.level, this.getBlockState(), this.worldPosition);
            }
        }
        this.updateInventory();
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.setChanged();
    }

    public ItemInteractionResult butcher(Player p, ItemStack butcheringTool) {
        Optional<RecipeHolder<HookRecipe>> recipeOptional = this.matchRecipe();
        if (recipeOptional.isPresent()) {
            HookRecipe recipe = (HookRecipe)recipeOptional.get().value();
            if (this.curTool == null) {
                this.setupStage(recipe, this.stage);
            }
            if (this.curTool.test(butcheringTool)) {
                if (butcheringTool.getCount() >= this.toolCount) {
                    ++this.progress;
                    if (this.progress >= this.maxProgress) {
                        if (!p.isCreative()) {
                            if (butcheringTool.isDamageableItem()) {
                                butcheringTool.hurtAndBreak(1, (LivingEntity)p, EquipmentSlot.MAINHAND);
                            } else {
                                butcheringTool.shrink(1);
                            }
                        }
                        if (this.isFinalStage(recipe)) {
                            this.dropLoot((AnimatedRecipeItemUse)recipe.tools().get(this.stage), p);
                            this.inflictEffects(p, (AnimatedRecipeItemUse)recipe.tools().get(this.stage));
                            this.finishRecipe();
                        } else {
                            this.dropLoot((AnimatedRecipeItemUse)recipe.tools().get(this.stage), p);
                            this.inflictEffects(p, (AnimatedRecipeItemUse)recipe.tools().get(this.stage));
                            this.setupStage(recipe, this.stage + 1);
                        }
                        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
                        this.level.playSound(p, this.worldPosition, SoundEvents.SLIME_SQUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        if (butcheringTool.isDamageableItem()) {
                            butcheringTool.hurtAndBreak(1, (LivingEntity)p, EquipmentSlot.MAINHAND);
                        } else {
                            butcheringTool.setCount(butcheringTool.getCount() - this.toolCount);
                        }
                        for (int i = 0; i < 1 + this.level.random.nextInt(4); ++i) {
                            this.level.addParticle((ParticleOptions)ParticleTypes.FALLING_LAVA, (double)((float)this.worldPosition.getX() + 0.25f) + this.level.random.nextDouble() / 2.0, (double)((float)this.worldPosition.getY() - 1.5f), (double)((float)this.worldPosition.getZ() + 0.25f) + this.level.random.nextDouble() / 2.0, 0.0, 0.0, 0.0);
                        }
                        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
                        this.level.playSound(p, this.worldPosition, SoundEvents.SLIME_SQUISH_SMALL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                this.updateInventory();
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void dropLoot(AnimatedRecipeItemUse recipeToolsIn, Player player) {
        if (this.level != null && !this.level.isClientSide()) {
            LootParams pParams = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.TOOL, (Object)player.getMainHandItem()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withLuck(player.getLuck() + (float)player.getMainHandItem().getEnchantmentLevel(player.registryAccess().holderOrThrow(Enchantments.FORTUNE))).create(LootContextParamSets.EMPTY);
            player.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)recipeToolsIn.lootTable())).getRandomItems(pParams).forEach(itemStack -> this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() - 1.5f), (double)((float)this.getBlockPos().getZ() + 0.5f), itemStack, 0.0, 0.0, 0.0)));
        }
    }

    private void inflictEffects(Player player, AnimatedRecipeItemUse recipeToolsIn) {
        for (RecipeMobEffect r : recipeToolsIn.effects()) {
            Optional e = BuiltInRegistries.MOB_EFFECT.getHolder(r.rc());
            if (!e.isPresent() || !(player.level().random.nextFloat() >= r.chance())) continue;
            player.addEffect(new MobEffectInstance((Holder)e.get(), r.duration(), r.amplify()));
        }
    }

    public void finishRecipe() {
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
        Block block = this.level.getBlockState(this.worldPosition).getBlock();
        if (block instanceof MeatHookBlock) {
            MeatHookBlock b = (MeatHookBlock)block;
            b.removeBelow(this.level, this.worldPosition);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("inventory")) {
            this.inventory.deserializeNBT(registries, nbt.getCompound("inventory"));
        }
        this.stage = nbt.getInt("stage");
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("stage", this.stage);
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }
}

