/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.hook;

import com.lance5057.butchercraft.workstations.hook.MeatHookBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MeatHookBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty DUMMY = IntegerProperty.create((String)"dummy", (int)0, (int)2);

    public MeatHookBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(3.0f, 4.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)DUMMY, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, DUMMY});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)DUMMY) == 0 ? state.getShape(level, pos) : Shapes.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ItemInteractionResult useItemOn(ItemStack heldMain, BlockState state, Level world, BlockPos blockPos, Player playerEntity, InteractionHand hand, BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)DUMMY) == 0) {
            BlockEntity entity = world.getBlockEntity(blockPos);
            if (!(entity instanceof MeatHookBlockEntity)) return ItemInteractionResult.CONSUME;
            MeatHookBlockEntity te = (MeatHookBlockEntity)entity;
            if (playerEntity.isCrouching()) {
                if (te.stage != 0 || te.progress != 0) return ItemInteractionResult.CONSUME;
                te.extractItem(playerEntity);
                return ItemInteractionResult.SUCCESS;
            }
            if (te.isEmpty()) {
                if (this.isEmptyBelow(world, blockPos)) {
                    te.insertItem(heldMain);
                    return ItemInteractionResult.SUCCESS;
                }
                playerEntity.displayClientMessage((Component)Component.translatable((String)"butchercraft.block.meathook.no_space"), true);
                return ItemInteractionResult.CONSUME;
            }
            if (!heldMain.is(Items.PAPER)) return te.butcher(playerEntity, heldMain);
            te.displayTools = !te.displayTools;
            return ItemInteractionResult.SUCCESS;
        }
        if ((Integer)state.getValue((Property)DUMMY) != 1) return world.getBlockState(blockPos.above(2)).useItemOn(heldMain, world, playerEntity, hand, hitResult.withPosition(blockPos.above(2)));
        BlockState state1 = world.getBlockState(blockPos.above());
        return state1.useItemOn(heldMain, world, playerEntity, hand, hitResult.withPosition(blockPos.above()));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if ((Integer)state.getValue((Property)DUMMY) == 0) {
            MeatHookBlockEntity te;
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof MeatHookBlockEntity && !(te = (MeatHookBlockEntity)entity).isEmpty()) {
                this.placeBelow(level, state, pos);
            }
        } else if ((Integer)state.getValue((Property)DUMMY) == 1) {
            level.getBlockState(pos.above()).handleNeighborChanged(level, pos.above(), neighborBlock, neighborPos, movedByPiston);
        } else {
            level.getBlockState(pos.above(2)).handleNeighborChanged(level, pos.above(2), neighborBlock, neighborPos, movedByPiston);
        }
    }

    boolean isEmptyBelow(Level level, BlockPos pos) {
        if (!level.isEmptyBlock(pos.below())) {
            return false;
        }
        return level.isEmptyBlock(pos.below(2));
    }

    void placeBelow(Level level, BlockState state, BlockPos pos) {
        if (level.isEmptyBlock(pos.below())) {
            level.setBlock(pos.below(), (BlockState)state.setValue((Property)DUMMY, (Comparable)Integer.valueOf(1)), 3);
        }
        if (level.isEmptyBlock(pos.below(2))) {
            level.setBlock(pos.below(2), (BlockState)state.setValue((Property)DUMMY, (Comparable)Integer.valueOf(2)), 3);
        }
    }

    void removeBelow(Level level, BlockPos pos) {
        if (level.getBlockState(pos.below()).getBlock() instanceof MeatHookBlock) {
            level.destroyBlock(pos.below(), false);
        }
        if (level.getBlockState(pos.below(2)).getBlock() instanceof MeatHookBlock) {
            level.destroyBlock(pos.below(2), false);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if ((Integer)pState.getValue((Property)DUMMY) == 0) {
            return new MeatHookBlockEntity(pPos, pState);
        }
        return null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if ((Integer)state.getValue((Property)DUMMY) == 0 && state.getBlock() != newState.getBlock()) {
            this.removeBelow(level, pos);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

