/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.hook;

import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.hook.HookRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class HookRecipeSerializer
implements RecipeSerializer<HookRecipe> {
    public static final MapCodec<HookRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(HookRecipe::group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("carcass").forGetter(HookRecipe::carcass), (App)NonNullList.codecOf(AnimatedRecipeItemUse.CODEC).fieldOf("tools").forGetter(HookRecipe::tools), (App)NonNullList.codecOf((Codec)Ingredient.CODEC_NONEMPTY).fieldOf("jei").forGetter(HookRecipe::jei)).apply((Applicative)inst, HookRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, HookRecipe> STREAM_CODEC = StreamCodec.of(HookRecipeSerializer::write, HookRecipeSerializer::read);

    public MapCodec<HookRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, HookRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static HookRecipe read(RegistryFriendlyByteBuf buffer) {
        String group = buffer.readUtf();
        Ingredient carcass = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        int listSize = buffer.readVarInt();
        NonNullList tools = NonNullList.withSize((int)listSize, (Object)AnimatedRecipeItemUse.EMPTY);
        tools.replaceAll(ignored -> (AnimatedRecipeItemUse)AnimatedRecipeItemUse.STREAM_CODEC.decode((Object)buffer));
        int jeiSize = buffer.readVarInt();
        NonNullList jei = NonNullList.withSize((int)jeiSize, (Object)Ingredient.EMPTY);
        jei.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
        return new HookRecipe(group, carcass, (NonNullList<AnimatedRecipeItemUse>)tools, (NonNullList<Ingredient>)jei);
    }

    private static void write(RegistryFriendlyByteBuf buffer, HookRecipe recipe) {
        buffer.writeUtf(recipe.getGroup());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.carcass());
        buffer.writeVarInt(recipe.tools().size());
        recipe.tools().forEach(riu -> AnimatedRecipeItemUse.STREAM_CODEC.encode((Object)buffer, riu));
        buffer.writeVarInt(recipe.jei().size());
        recipe.jei().forEach(i -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, i));
    }
}

