/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.grinder;

import com.lance5057.butchercraft.client.rendering.RenderUtil;
import com.lance5057.butchercraft.workstations.grinder.GrinderBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.renderable.BakedModelRenderable;
import net.neoforged.neoforge.client.model.renderable.IRenderable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.joml.Quaternionf;

public class GrinderRenderer
implements BlockEntityRenderer<GrinderBlockEntity> {
    int timer = 0;
    ModelResourceLocation rc = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butchercraft", (String)"meathook/grinder_handle"));
    IRenderable<ModelData> model = BakedModelRenderable.of((ModelResourceLocation)this.rc).withModelDataContext();

    public GrinderRenderer(BlockEntityRendererProvider.Context cxt) {
    }

    public void render(GrinderBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        pPoseStack.pushPose();
        Quaternionf q = ((Direction)pBlockEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getRotation();
        pPoseStack.translate(0.5, 0.23, 0.5);
        pPoseStack.mulPose(q);
        pPoseStack.mulPose(RenderUtil.createQuaternion(0.0f, 0.0f, 180.0f, true));
        pPoseStack.translate(0.0, 0.34, 0.0);
        float g = pBlockEntity.getGrind();
        float mg = pBlockEntity.getMaxGrind();
        float r = mg == 0.0f ? 1.0f : 360.0f / (mg + 1.0f);
        pPoseStack.mulPose(RenderUtil.createQuaternion(0.0f, g * r, 0.0f, true));
        pPoseStack.translate(-0.5, 0.0, -0.05);
        this.model.render(pPoseStack, pBufferSource, texture -> RenderType.entityTranslucent((ResourceLocation)texture), pPackedLight, pPackedOverlay, pPartialTick, (Object)ModelData.EMPTY);
        pPoseStack.popPose();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStackHandler inv = pBlockEntity.getHandler();
        ItemStack input = inv.getStackInSlot(0);
        ItemStack tip = inv.getStackInSlot(1);
        ItemStack casing = inv.getStackInSlot(2);
        float t = mg == 0.0f ? 1.0f : -0.3f / mg;
        this.renderRotatedItem(pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, q, itemRenderer, input, 0.5, 1.5 + (double)(g * t), 0.175, 0.0f, 90.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.renderRotatedItem(pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, q, itemRenderer, tip, 0.5, 1.22, 0.925, 90.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.renderRotatedItem(pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, q, itemRenderer, casing, 0.5, 1.11, 0.9 - (double)(g * t), 0.0f, 90.0f, 0.0f, 1.0f, 1.0f, 2.1f);
        ++this.timer;
    }

    private void renderRotatedItem(GrinderBlockEntity pBlockEntity, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, Quaternionf q, ItemRenderer itemRenderer, ItemStack input, double xt, double yt, double zt, float xr, float yr, float zr, float xs, float ys, float zs) {
        if (!input.isEmpty()) {
            BakedModel bakedmodel = itemRenderer.getModel(input, pBlockEntity.getLevel(), null, 0);
            pPoseStack.pushPose();
            pPoseStack.translate(0.5f, -1.0f, 0.5f);
            pPoseStack.mulPose(q);
            pPoseStack.mulPose(RenderUtil.createQuaternion(-90.0f, 0.0f, 0.0f, true));
            pPoseStack.translate(-0.5f, 0.0f, -0.5f);
            pPoseStack.translate(xt, yt, zt);
            pPoseStack.mulPose(RenderUtil.createQuaternion(xr, yr, zr, true));
            pPoseStack.scale(xs, ys, zs);
            float uniscale = 1.0f;
            pPoseStack.scale(uniscale, uniscale, uniscale);
            itemRenderer.render(input, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, bakedmodel);
            pPoseStack.popPose();
        }
    }
}

