/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.grinder;

import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class GrinderRecipeSerializer
implements RecipeSerializer<GrinderRecipe> {
    private static final MapCodec<GrinderRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(GrinderRecipe::group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(GrinderRecipe::ingredient), (App)Codec.INT.fieldOf("ingredientCount").forGetter(GrinderRecipe::count), (App)Ingredient.CODEC_NONEMPTY.fieldOf("attachment").forGetter(GrinderRecipe::attachment), (App)ItemStack.CODEC.fieldOf("result").forGetter(GrinderRecipe::result), (App)Codec.INT.fieldOf("grinds").forGetter(GrinderRecipe::grinds)).apply((Applicative)inst, GrinderRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GrinderRecipe> STREAM_CODEC = StreamCodec.of(GrinderRecipeSerializer::write, GrinderRecipeSerializer::read);

    public MapCodec<GrinderRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, GrinderRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static GrinderRecipe read(RegistryFriendlyByteBuf pBuffer) {
        String s = pBuffer.readUtf();
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
        int c = pBuffer.readInt();
        Ingredient attachment = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
        ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
        int g = pBuffer.readInt();
        return new GrinderRecipe(s, ingredient, c, attachment, itemstack, g);
    }

    private static void write(RegistryFriendlyByteBuf pBuffer, GrinderRecipe pRecipe) {
        pBuffer.writeUtf(pRecipe.getGroup());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.ingredient());
        pBuffer.writeInt(pRecipe.count());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.attachment());
        ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result());
        pBuffer.writeInt(pRecipe.grinds());
    }
}

