/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.grinder;

import com.lance5057.butchercraft.ButchercraftRecipeSerializers;
import com.lance5057.butchercraft.ButchercraftRecipes;
import com.lance5057.butchercraft.workstations.grinder.GrinderContainer;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record GrinderRecipe(String group, Ingredient ingredient, int count, Ingredient attachment, ItemStack result, int grinds) implements Recipe<GrinderContainer>
{
    public boolean matches(GrinderContainer pContainer, Level pLevel) {
        return this.ingredient.test(pContainer.getInsertedItem()) && this.attachment.test(pContainer.getAttachment());
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ButchercraftRecipeSerializers.GRINDER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ButchercraftRecipes.GRINDER.get();
    }

    public ItemStack assemble(GrinderContainer pContainer, HolderLookup.Provider registryAccess) {
        return this.result.copy();
    }
}

