/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.grinder;

import com.lance5057.butchercraft.ButchercraftBlockEntities;
import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.ButchercraftRecipes;
import com.lance5057.butchercraft.tags.ButchercraftItemTags;
import com.lance5057.butchercraft.workstations.BlockEntityItemHandler;
import com.lance5057.butchercraft.workstations.grinder.GrinderBlock;
import com.lance5057.butchercraft.workstations.grinder.GrinderContainer;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GrinderBlockEntity
extends BlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final Lazy<ItemStackHandler> itemHandler = Lazy.of(() -> this.inventory);
    private ItemStack output = ItemStack.EMPTY;
    private int itemsUsed = 0;
    private int grinds = 0;
    private int grindsMax = 0;
    private boolean isExtruder = false;

    public GrinderBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ButchercraftBlockEntities.GRINDER.get(), pPos, pState);
    }

    public ItemStackHandler getHandler() {
        return (ItemStackHandler)this.itemHandler.get();
    }

    private ItemStackHandler createHandler() {
        return new BlockEntityItemHandler<GrinderBlockEntity>(this, 3){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 1) {
                    return stack.is(ButchercraftItemTags.GRINDER_ATTACHMENT);
                }
                if (slot == 2) {
                    return stack.is(ButchercraftItemTags.SAUSAGE_CASING) && this.getStackInSlot(1).is((Item)ButchercraftItems.EXTRUDER_TIP.get());
                }
                return true;
            }

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return 8;
                }
                return 1;
            }

            protected void onContentsChanged(int slot) {
                GrinderBlockEntity.this.updateInventory();
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (this.getStackInSlot(slot) == ItemStack.EMPTY) {
                    if (slot == 0) {
                        Optional r = GrinderBlockEntity.this.level.getRecipeManager().getRecipeFor((RecipeType)ButchercraftRecipes.GRINDER.get(), (RecipeInput)new GrinderContainer(stack, this.getStackInSlot(1)), GrinderBlockEntity.this.level);
                        if (r.isPresent()) {
                            ((GrinderBlockEntity)((Object)this.getBlockEntity())).setupRecipe(((GrinderRecipe)((RecipeHolder)r.get()).value()).grinds(), ((GrinderRecipe)((RecipeHolder)r.get()).value()).getResultItem(null), this.getStackInSlot(1), ((GrinderRecipe)((RecipeHolder)r.get()).value()).count());
                            ((GrinderBlockEntity)((Object)this.getBlockEntity())).updateInventory();
                            return super.insertItem(slot, stack, simulate);
                        }
                    } else {
                        ((GrinderBlockEntity)((Object)this.getBlockEntity())).updateInventory();
                        return super.insertItem(slot, stack, simulate);
                    }
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ((GrinderBlockEntity)((Object)this.getBlockEntity())).zeroProgress();
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    public void extractItem(Player playerEntity) {
        if (!this.inventory.getStackInSlot(0).isEmpty()) {
            ItemStack itemStack = this.inventory.getStackInSlot(0).copy();
            playerEntity.addItem(itemStack);
            this.inventory.setStackInSlot(0, ItemStack.EMPTY);
            this.zeroProgress();
            this.updateInventory();
            return;
        }
        if (!this.inventory.getStackInSlot(2).isEmpty()) {
            ItemStack itemStack = this.inventory.getStackInSlot(2).copy();
            playerEntity.addItem(itemStack);
            this.inventory.setStackInSlot(2, ItemStack.EMPTY);
            this.zeroProgress();
            this.updateInventory();
            return;
        }
        if (!this.inventory.getStackInSlot(1).isEmpty() && this.inventory.getStackInSlot(0).isEmpty()) {
            ItemStack itemStack = this.inventory.getStackInSlot(1).copy();
            playerEntity.addItem(itemStack);
            this.inventory.setStackInSlot(1, ItemStack.EMPTY);
            this.zeroProgress();
            this.updateInventory();
            return;
        }
        this.updateInventory();
    }

    public ItemStack insertItem(ItemStack heldItem) {
        for (int i = 0; i < 3; ++i) {
            if (!this.inventory.isItemValid(i, heldItem) || ItemStack.matches((ItemStack)this.inventory.insertItem(i, heldItem, true), (ItemStack)heldItem)) continue;
            heldItem = this.inventory.insertItem(i, heldItem.copy(), false);
            this.updateInventory();
            return heldItem;
        }
        this.updateInventory();
        return heldItem;
    }

    public void zeroProgress() {
        this.itemsUsed = 0;
        this.grinds = 0;
        this.grindsMax = 0;
        this.output = ItemStack.EMPTY;
        this.isExtruder = false;
    }

    public void setupRecipe(int grindsMax, ItemStack output, ItemStack extruder, int used) {
        this.zeroProgress();
        this.grindsMax = grindsMax;
        this.output = output;
        this.itemsUsed = used;
        if (extruder.is((Item)ButchercraftItems.EXTRUDER_TIP.get())) {
            this.isExtruder = true;
        }
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public ItemStack getInsertedItem() {
        return this.inventory.getStackInSlot(0);
    }

    public ItemStack getAttachment() {
        return this.inventory.getStackInSlot(1);
    }

    public ItemStack getCasing() {
        return this.inventory.getStackInSlot(2);
    }

    public int getGrind() {
        return this.grinds;
    }

    public int getMaxGrind() {
        return this.grindsMax;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        nbt = this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("inventory")) {
            this.inventory.deserializeNBT(registries, nbt.getCompound("inventory"));
        }
        this.grinds = nbt.getInt("grinds");
        this.grindsMax = nbt.getInt("grinds_max");
        this.output = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("output"));
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("grinds", this.grinds);
        tag.putInt("grinds_max", this.grindsMax);
        if (!this.output.isEmpty()) {
            tag.put("output", this.output.save(registries, (Tag)new CompoundTag()));
        }
        return tag;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.readNBT(tag, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt = this.writeNBT(nbt, registries);
    }

    public Optional<RecipeHolder<GrinderRecipe>> matchRecipe(ItemStack ingredient, ItemStack attachment) {
        if (this.level != null) {
            return this.level.getRecipeManager().getRecipeFor((RecipeType)ButchercraftRecipes.GRINDER.get(), (RecipeInput)new GrinderContainer(ingredient, attachment), this.level);
        }
        return Optional.empty();
    }

    public ItemInteractionResult grind(Player Player2, BlockState blockState) {
        if (!this.output.isEmpty()) {
            if (this.isExtruder && this.getCasing().isEmpty()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (this.getInsertedItem().getCount() < this.itemsUsed) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (this.grinds < this.grindsMax) {
                ++this.grinds;
                for (int i = 0; i < 1 + this.level.random.nextInt(4); ++i) {
                    this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getInsertedItem()), (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.25f), (double)((float)this.worldPosition.getZ() + 0.25f), 0.0, 0.0, (double)-0.1f);
                }
                this.level.playSound(Player2, this.worldPosition, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                ItemStack in = this.inventory.getStackInSlot(0);
                ItemStack casing = this.inventory.getStackInSlot(2);
                if (!casing.isEmpty() && !in.isEmpty()) {
                    for (int i = 0; i < casing.getCount(); ++i) {
                        ItemStack r = this.output.copy();
                        this.dropLoot(blockState, r);
                    }
                } else {
                    ItemStack r = this.output.copy();
                    this.dropLoot(blockState, r);
                }
                ItemStack s = in.copy();
                s.setCount(in.getCount() - this.itemsUsed);
                this.inventory.setStackInSlot(0, ItemStack.EMPTY);
                this.inventory.setStackInSlot(2, ItemStack.EMPTY);
                this.output = ItemStack.EMPTY;
                if (this.inventory.isItemValid(0, s)) {
                    this.dropLoot(blockState, this.inventory.insertItem(0, s, false));
                }
            }
            this.updateInventory();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void dropLoot(BlockState blockState, ItemStack item) {
        Direction d = (Direction)blockState.getValue((Property)GrinderBlock.FACING);
        switch (d) {
            case NORTH: {
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)(this.getBlockPos().getX() + 1), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), item, 0.0, 0.0, 0.0));
                break;
            }
            case SOUTH: {
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)((float)this.getBlockPos().getX() + 0.5f), (double)this.getBlockPos().getY(), (double)((float)this.getBlockPos().getZ() + 1.25f), item, 0.0, 0.0, (double)0.1f));
                break;
            }
            case EAST: {
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)(this.getBlockPos().getZ() + 1), item, 0.0, 0.0, 0.0));
                break;
            }
            case WEST: {
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)(this.getBlockPos().getZ() - 1), item, 0.0, 0.0, 0.0));
                break;
            }
        }
    }
}

