/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.butcherblock;

import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ButcherBlockSerializer
implements RecipeSerializer<ButcherBlockRecipe> {
    public static final MapCodec<ButcherBlockRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ButcherBlockRecipe::group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("carcass").forGetter(ButcherBlockRecipe::carcass), (App)NonNullList.codecOf(AnimatedRecipeItemUse.CODEC).fieldOf("tools").forGetter(ButcherBlockRecipe::tools), (App)NonNullList.codecOf((Codec)Ingredient.CODEC_NONEMPTY).fieldOf("jei").forGetter(ButcherBlockRecipe::jei)).apply((Applicative)inst, ButcherBlockRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ButcherBlockRecipe> STREAM_CODEC = StreamCodec.of(ButcherBlockSerializer::write, ButcherBlockSerializer::read);

    public MapCodec<ButcherBlockRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ButcherBlockRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static ButcherBlockRecipe read(RegistryFriendlyByteBuf buffer) {
        String group = buffer.readUtf();
        Ingredient carcassIn = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        int listSize = buffer.readVarInt();
        NonNullList tools = NonNullList.withSize((int)listSize, (Object)AnimatedRecipeItemUse.EMPTY);
        tools.replaceAll(ignored -> (AnimatedRecipeItemUse)AnimatedRecipeItemUse.STREAM_CODEC.decode((Object)buffer));
        int jeiSize = buffer.readVarInt();
        NonNullList jei = NonNullList.withSize((int)jeiSize, (Object)Ingredient.EMPTY);
        jei.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
        return new ButcherBlockRecipe(group, carcassIn, (NonNullList<AnimatedRecipeItemUse>)tools, (NonNullList<Ingredient>)jei);
    }

    private static void write(RegistryFriendlyByteBuf buffer, ButcherBlockRecipe recipe) {
        buffer.writeUtf(recipe.getGroup());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.carcass());
        buffer.writeVarInt(recipe.tools().size());
        recipe.tools().forEach(riu -> AnimatedRecipeItemUse.STREAM_CODEC.encode((Object)buffer, riu));
        buffer.writeVarInt(recipe.jei().size());
        recipe.jei().forEach(i -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, i));
    }
}

