/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.butcherblock;

import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ButcherBlockBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty DUMMY = BooleanProperty.create((String)"dummy");

    public ButcherBlockBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(3.0f, 4.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)DUMMY, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, DUMMY});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)DUMMY) == false ? state.getShape(level, pos) : Shapes.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ItemInteractionResult useItemOn(ItemStack heldMain, BlockState state, Level world, BlockPos blockPos, Player playerEntity, InteractionHand hand, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)DUMMY)).booleanValue()) return world.getBlockState(blockPos.below()).useItemOn(heldMain, world, playerEntity, hand, hitResult.withPosition(blockPos.below()));
        BlockEntity entity = world.getBlockEntity(blockPos);
        if (!(entity instanceof ButcherBlockBlockEntity)) return ItemInteractionResult.CONSUME;
        ButcherBlockBlockEntity te = (ButcherBlockBlockEntity)entity;
        if (playerEntity.isCrouching()) {
            if (te.stage != 0 || te.progress != 0) return ItemInteractionResult.CONSUME;
            te.extractItem(playerEntity);
            return ItemInteractionResult.SUCCESS;
        }
        if (te.isEmpty()) {
            if (this.isEmptyAbove(world, blockPos)) {
                te.insertItem(heldMain);
                return ItemInteractionResult.SUCCESS;
            }
            playerEntity.displayClientMessage((Component)Component.translatable((String)"butchercraft.block.butcherblock.no_space"), true);
            return ItemInteractionResult.CONSUME;
        }
        if (!heldMain.is(Items.PAPER)) return te.butcher(playerEntity, heldMain);
        te.displayTools = !te.displayTools;
        return ItemInteractionResult.SUCCESS;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!((Boolean)state.getValue((Property)DUMMY)).booleanValue()) {
            ButcherBlockBlockEntity te;
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof ButcherBlockBlockEntity && !(te = (ButcherBlockBlockEntity)entity).isEmpty()) {
                this.placeAbove(level, state, pos);
            }
        } else {
            level.getBlockState(pos.above()).handleNeighborChanged(level, neighborPos, neighborBlock, pos.above(), movedByPiston);
        }
    }

    boolean isEmptyAbove(Level level, BlockPos pos) {
        return level.isEmptyBlock(pos.above());
    }

    void placeAbove(Level level, BlockState state, BlockPos pos) {
        if (level.isEmptyBlock(pos.above())) {
            level.setBlock(pos.above(), (BlockState)state.setValue((Property)DUMMY, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    void removeAbove(Level level, BlockPos pos) {
        if (level.getBlockState(pos.above()).getBlock() instanceof ButcherBlockBlock) {
            level.destroyBlock(pos.above(), false);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (!((Boolean)pState.getValue((Property)DUMMY)).booleanValue()) {
            return new ButcherBlockBlockEntity(pPos, pState);
        }
        return null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            this.removeAbove(level, pos);
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

