/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.bases.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record RecipeMobEffect(ResourceLocation rc, int duration, int amplify, float chance) {
    public static final Codec<RecipeMobEffect> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(RecipeMobEffect::rc), (App)Codec.INT.optionalFieldOf("duration", (Object)100).forGetter(RecipeMobEffect::duration), (App)Codec.INT.optionalFieldOf("amplification", (Object)1).forGetter(RecipeMobEffect::amplify), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(0.1f)).forGetter(RecipeMobEffect::chance)).apply((Applicative)inst, RecipeMobEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeMobEffect> STREAM_CODEC = StreamCodec.of(RecipeMobEffect::write, RecipeMobEffect::read);
    public static RecipeMobEffect EMPTY = new RecipeMobEffect(ResourceLocation.fromNamespaceAndPath((String)"", (String)""), 0, 0, 0.0f);

    private static RecipeMobEffect read(RegistryFriendlyByteBuf buffer) {
        ResourceLocation rc = buffer.readResourceLocation();
        int dur = buffer.readInt();
        int amp = buffer.readInt();
        float chan = buffer.readFloat();
        return new RecipeMobEffect(rc, dur, amp, chan);
    }

    private static void write(RegistryFriendlyByteBuf buffer, RecipeMobEffect bm) {
        buffer.writeResourceLocation(bm.rc);
        buffer.writeInt(bm.duration);
        buffer.writeInt(bm.amplify);
        buffer.writeFloat(bm.chance);
    }
}

