/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.bases.recipes;

import com.lance5057.butchercraft.client.BlacklistedModel;
import com.lance5057.butchercraft.util.RecipeItemUse;
import com.lance5057.butchercraft.workstations.bases.recipes.RecipeMobEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public record AnimatedRecipeItemUse(int uses, Ingredient tool, int count, boolean damageTool, ResourceLocation lootTable, List<RecipeMobEffect> effects, List<BlacklistedModel> model) {
    public static final Codec<AnimatedRecipeItemUse> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("uses").forGetter(AnimatedRecipeItemUse::uses), (App)Ingredient.CODEC_NONEMPTY.fieldOf("tool").forGetter(AnimatedRecipeItemUse::tool), (App)Codec.INT.fieldOf("count").forGetter(AnimatedRecipeItemUse::count), (App)Codec.BOOL.fieldOf("damage").forGetter(AnimatedRecipeItemUse::damageTool), (App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(AnimatedRecipeItemUse::lootTable), (App)Codec.list(RecipeMobEffect.CODEC).fieldOf("effects").forGetter(AnimatedRecipeItemUse::effects), (App)Codec.list(BlacklistedModel.CODEC).fieldOf("models").forGetter(AnimatedRecipeItemUse::model)).apply((Applicative)inst, AnimatedRecipeItemUse::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnimatedRecipeItemUse> STREAM_CODEC = StreamCodec.of(AnimatedRecipeItemUse::write, AnimatedRecipeItemUse::read);
    public static final AnimatedRecipeItemUse EMPTY = new AnimatedRecipeItemUse(RecipeItemUse.EMPTY, List.of(), BlacklistedModel.empty);

    public AnimatedRecipeItemUse(RecipeItemUse riu, List<RecipeMobEffect> e, BlacklistedModel ... model) {
        this(riu.uses(), riu.tool(), riu.count(), riu.damageTool(), riu.lootTable(), e, List.of(model));
    }

    private static AnimatedRecipeItemUse read(RegistryFriendlyByteBuf buffer) {
        RecipeItemUse riu = (RecipeItemUse)RecipeItemUse.STREAM_CODEC.decode((Object)buffer);
        int size = buffer.readInt();
        BlacklistedModel[] b = new BlacklistedModel[size];
        for (int i = 0; i < size; ++i) {
            b[i] = (BlacklistedModel)BlacklistedModel.STREAM_CODEC.decode((Object)buffer);
        }
        int size2 = buffer.readInt();
        RecipeMobEffect[] r = new RecipeMobEffect[size2];
        for (int i = 0; i < size2; ++i) {
            r[i] = (RecipeMobEffect)RecipeMobEffect.STREAM_CODEC.decode((Object)buffer);
        }
        return new AnimatedRecipeItemUse(riu, List.of(r), b);
    }

    private static void write(RegistryFriendlyByteBuf buffer, AnimatedRecipeItemUse r) {
        int i;
        buffer.writeVarInt(r.uses);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)r.tool);
        buffer.writeVarInt(r.count);
        buffer.writeBoolean(r.damageTool);
        buffer.writeResourceLocation(r.lootTable);
        buffer.writeInt(r.model.size());
        for (i = 0; i < r.model.size(); ++i) {
            BlacklistedModel.STREAM_CODEC.encode((Object)buffer, (Object)r.model.get(i));
        }
        buffer.writeInt(r.effects.size());
        for (i = 0; i < r.effects.size(); ++i) {
            RecipeMobEffect.STREAM_CODEC.encode((Object)buffer, (Object)r.effects.get(i));
        }
    }
}

