/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public record RecipeItemUse(int uses, Ingredient tool, int count, boolean damageTool, ResourceLocation lootTable) {
    public static final Codec<RecipeItemUse> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("uses").forGetter(RecipeItemUse::uses), (App)Ingredient.CODEC_NONEMPTY.fieldOf("tool").forGetter(RecipeItemUse::tool), (App)Codec.INT.fieldOf("count").forGetter(RecipeItemUse::count), (App)Codec.BOOL.fieldOf("damage").forGetter(RecipeItemUse::damageTool), (App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(RecipeItemUse::lootTable)).apply((Applicative)inst, RecipeItemUse::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeItemUse> STREAM_CODEC = StreamCodec.of(RecipeItemUse::write, RecipeItemUse::read);
    public static final RecipeItemUse EMPTY = new RecipeItemUse(0, Ingredient.EMPTY, 1, false, ResourceLocation.fromNamespaceAndPath((String)"", (String)""));

    private static RecipeItemUse read(RegistryFriendlyByteBuf buffer) {
        int u = buffer.readVarInt();
        Ingredient i = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        int c = buffer.readVarInt();
        boolean b = buffer.readBoolean();
        ResourceLocation s = buffer.readResourceLocation();
        return new RecipeItemUse(u, i, c, b, s);
    }

    private static void write(RegistryFriendlyByteBuf buffer, RecipeItemUse r) {
        buffer.writeVarInt(r.uses);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)r.tool);
        buffer.writeVarInt(r.count);
        buffer.writeBoolean(r.damageTool);
        buffer.writeResourceLocation(r.lootTable);
    }
}

