/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.items;

import com.lance5057.butchercraft.ButchercraftMobEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class SoapItem
extends Item {
    public SoapItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        if (!pLevel.isClientSide) {
            pEntityLiving.removeEffectsCuredBy(ButchercraftMobEffects.SOAP);
        }
        if (pEntityLiving instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)pEntityLiving;
            pStack.hurtAndBreak(1, (ServerLevel)pLevel, serverplayer, r -> {});
        }
        return pStack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.CUSTOM;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        pLevel.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, pPlayer.getX() + 0.25 + pLevel.random.nextDouble() / 2.0, pPlayer.getY() + 0.5 + pLevel.random.nextDouble(), pPlayer.getZ() + 0.25 + pLevel.random.nextDouble() / 2.0, 0.0, 0.0, 0.0);
        return ItemUtils.startUsingInstantly((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            Player p = (Player)pEntity;
            if ((pIsSelected || p.getInventory().getItem(40).is(pStack.getItem())) && p.getUseItemRemainingTicks() > 0) {
                for (int i = 0; i < 10; ++i) {
                    pLevel.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, p.getX() + (double)pLevel.random.nextFloat() - 0.5, p.getY() + (double)(pLevel.random.nextFloat() * 2.0f), p.getZ() + (double)pLevel.random.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                    pLevel.addParticle((ParticleOptions)ParticleTypes.BUBBLE, p.getX() + (double)pLevel.random.nextFloat() - 0.5, p.getY() + (double)(pLevel.random.nextFloat() * 2.0f), p.getZ() + (double)pLevel.random.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

