/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.items;

import com.lance5057.butchercraft.ButchercraftMobEffects;
import com.lance5057.butchercraft.items.KnifeItem;
import com.lance5057.butchercraft.tags.ButchercraftEntityTags;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.common.IShearable;

public class ButcherKnifeItem
extends KnifeItem {
    public ButcherKnifeItem(Item.Properties builderIn) {
        super(builderIn);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.hasEffect(ButchercraftMobEffects.BLOODLUST)) {
            return InteractionResult.FAIL;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (entity.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = new BlockPos(entity.getBlockX(), entity.getBlockY(), entity.getBlockZ());
            if (target.isShearable(player, stack, entity.level(), pos)) {
                List drops = target.onSheared(player, stack, entity.level(), pos);
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.spawnAtLocation(d, 1.0f);
                    ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
            }
        }
        if (player.getServer() != null && entity.getType().is(ButchercraftEntityTags.CARCASSES) && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!this.specialCases(player, mob)) {
                ResourceKey lootTableLocation = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butchercraft", (String)("butcher_knife/" + BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).getPath())));
                LootTable lootTable = player.getServer().reloadableRegistries().getLootTable(lootTableLocation);
                if (lootTable != LootTable.EMPTY) {
                    this.killAndDrop(player, (ResourceKey<LootTable>)lootTableLocation, mob);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void killAndDrop(Player player, ResourceKey<LootTable> lootTableLocation, Mob mob) {
        player.level().playSound(null, mob.blockPosition(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.0f, 1.0f);
        mob.lootTable = lootTableLocation;
        mob.setLastHurtByPlayer(player);
        mob.hurt(player.damageSources().playerAttack(player), 99999.0f);
    }

    boolean specialCases(Player player, Mob mob) {
        if (mob instanceof Rabbit) {
            Rabbit r = (Rabbit)mob;
            switch (r.getVariant()) {
                case BLACK: {
                    this.rabbitDrop(player, mob, "_black");
                    return true;
                }
                case BROWN: {
                    this.rabbitDrop(player, mob, "_brown");
                    return true;
                }
                case GOLD: {
                    this.rabbitDrop(player, mob, "_gold");
                    return true;
                }
                case SALT: {
                    this.rabbitDrop(player, mob, "_salt");
                    return true;
                }
                case WHITE: {
                    this.rabbitDrop(player, mob, "_white");
                    return true;
                }
                case WHITE_SPLOTCHED: {
                    this.rabbitDrop(player, mob, "_splotched");
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void rabbitDrop(Player player, Mob mob, String type) {
        ResourceKey lootTableLocation = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butchercraft", (String)("butcher_knife/" + BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType()).getPath() + type)));
        LootTable lootTable = player.getServer().reloadableRegistries().getLootTable(lootTableLocation);
        if (lootTable != LootTable.EMPTY) {
            this.killAndDrop(player, (ResourceKey<LootTable>)lootTableLocation, mob);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"").append((Component)Component.translatable((String)"butchercraft.butcherknife.rightclick")).withStyle(ChatFormatting.DARK_PURPLE));
    }
}

