/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.integration.jei.categories;

import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ButcherBlockRecipeCategory
implements IRecipeCategory<ButcherBlockRecipe> {
    public static final RecipeType<ButcherBlockRecipe> TYPE = RecipeType.create((String)"butchercraft", (String)"butcher_block", ButcherBlockRecipe.class);
    private final Component localizedName = Component.translatable((String)"Butchercraft.jei.butcherblock");
    private final IDrawable icon;

    public ButcherBlockRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ButchercraftItems.BUTCHER_BLOCK_BLOCK_ITEM.get()));
    }

    public RecipeType<ButcherBlockRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public int getWidth() {
        return 144;
    }

    public int getHeight() {
        return 144;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ButcherBlockRecipe recipe, IFocusGroup focuses) {
        int count = recipe.tools().size();
        int offset = 2;
        int width = 16 + offset;
        int placementH = 0;
        int height = 16 + offset;
        int placementW = 0;
        int c = 0;
        builder.addSlot(RecipeIngredientRole.INPUT, this.getWidth() / 2 - 8, 40).addIngredients(recipe.carcass());
        for (AnimatedRecipeItemUse a : recipe.tools()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 1 + placementW, 1 + placementH).addIngredients(a.tool());
            placementW += width;
            if (++c <= 7) continue;
            placementH += height;
            placementW = 0;
            c = 0;
        }
        c = 0;
        placementW = 0;
        placementH = 0;
        for (Ingredient i : recipe.jei()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 1 + placementW, 73 + placementH + 18).addIngredients(i);
            placementW += width;
            if (++c <= 7) continue;
            placementH += height;
            placementW = 0;
            c = 0;
        }
    }

    public void draw(ButcherBlockRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"butchercraft", (String)"textures/gui/jei.png"), 0, 0, 108, 78, 144, 144);
    }
}

