/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.integration.jei;

import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.ButchercraftRecipes;
import com.lance5057.butchercraft.integration.jei.categories.ButcherBlockRecipeCategory;
import com.lance5057.butchercraft.integration.jei.categories.GrinderRecipeCategory;
import com.lance5057.butchercraft.integration.jei.categories.MeatHookRecipeCategory;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"butchercraft", (String)"main");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new GrinderRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ButcherBlockRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new MeatHookRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        registry.addRecipes(GrinderRecipeCategory.TYPE, Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ButchercraftRecipes.GRINDER.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(MeatHookRecipeCategory.TYPE, Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ButchercraftRecipes.HOOK.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(ButcherBlockRecipeCategory.TYPE, Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ButchercraftRecipes.BUTCHER_BLOCK.get()).stream().map(RecipeHolder::value).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ButchercraftItems.BUTCHER_BLOCK_BLOCK_ITEM.get()), new RecipeType[]{ButcherBlockRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ButchercraftItems.HOOK_BLOCK_ITEM.get()), new RecipeType[]{MeatHookRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ButchercraftItems.GRINDER_BLOCK_ITEM.get()), new RecipeType[]{GrinderRecipeCategory.TYPE});
    }
}

