/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.integration.emi.recipes;

import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.integration.emi.EMIPlugin;
import com.lance5057.butchercraft.tags.ButchercraftItemTags;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class GrinderEmiRecipe
implements EmiRecipe {
    private final List<EmiIngredient> inputs;
    private final List<EmiIngredient> catalysts;
    private final List<EmiStack> outputs;
    private final ResourceLocation id;
    private final int grinds;
    private final int count;

    public GrinderEmiRecipe(GrinderRecipe recipe, ResourceLocation id) {
        this.inputs = List.of(EmiIngredient.of((Ingredient)recipe.ingredient()));
        ArrayList catalysts = Lists.newArrayList();
        catalysts.add(EmiIngredient.of((Ingredient)recipe.attachment()));
        if (recipe.attachment().test(ButchercraftItems.EXTRUDER_TIP.toStack())) {
            catalysts.add(EmiIngredient.of(ButchercraftItemTags.SAUSAGE_CASING));
        }
        this.catalysts = catalysts;
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.result()));
        this.id = id;
        this.grinds = recipe.grinds();
        this.count = recipe.count();
    }

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.GRINDER_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 138;
    }

    public int getDisplayHeight() {
        return 77;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(ResourceLocation.fromNamespaceAndPath((String)"butchercraft", (String)"textures/gui/jei.png"), 0, 0, 138, 77, 0, 0);
        widgets.addText((Component)Component.literal((String)("x" + this.grinds)), this.getDisplayWidth() / 2 - 57, 65, 0xFFFFFF, true);
        widgets.addText((Component)Component.literal((String)("x" + this.count)), this.getDisplayWidth() / 2 + 1, 18, 0xFFFFFF, true);
        widgets.addSlot(this.inputs.getFirst(), this.getDisplayWidth() / 2 - 18, 10).drawBack(false);
        widgets.addSlot(this.catalysts.getFirst(), this.getDisplayWidth() / 2 + 26, 49).drawBack(false);
        if (this.catalysts.size() > 1) {
            widgets.addSlot(this.catalysts.getLast(), this.getDisplayWidth() / 2 + 26, 27).drawBack(false);
        }
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), this.getDisplayWidth() / 2 + 50, 49).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

