/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.integration.emi;

import com.lance5057.butchercraft.ButchercraftBlocks;
import com.lance5057.butchercraft.ButchercraftRecipes;
import com.lance5057.butchercraft.integration.emi.recipes.ButcherBlockEmiRecipe;
import com.lance5057.butchercraft.integration.emi.recipes.GrinderEmiRecipe;
import com.lance5057.butchercraft.integration.emi.recipes.MeatHookEmiRecipe;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockRecipe;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import com.lance5057.butchercraft.workstations.hook.HookRecipe;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

@EmiEntrypoint
public class EMIPlugin
implements EmiPlugin {
    public static final EmiStack BUTCHER_BLOCK_WORKSTATION = EmiStack.of(ButchercraftBlocks.BUTCHER_BLOCK);
    public static final EmiStack GRINDER_WORKSTATION = EmiStack.of(ButchercraftBlocks.GRINDER);
    public static final EmiStack MEAT_HOOK_WORKSTATION = EmiStack.of(ButchercraftBlocks.MEAT_HOOK);
    public static final EmiRecipeCategory BUTCHER_BLOCK_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"butchercraft", (String)"butcher_block"), (EmiRenderable)BUTCHER_BLOCK_WORKSTATION){

        public Component getName() {
            return Component.translatable((String)"Butchercraft.jei.butcherblock");
        }
    };
    public static final EmiRecipeCategory GRINDER_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"butchercraft", (String)"grinder"), (EmiRenderable)GRINDER_WORKSTATION){

        public Component getName() {
            return Component.translatable((String)"Butchercraft.jei.grinder");
        }
    };
    public static final EmiRecipeCategory MEAT_HOOK_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"butchercraft", (String)"hook"), (EmiRenderable)MEAT_HOOK_WORKSTATION){

        public Component getName() {
            return Component.translatable((String)"Butchercraft.jei.hook");
        }
    };

    public void register(EmiRegistry registry) {
        registry.addCategory(BUTCHER_BLOCK_CATEGORY);
        registry.addCategory(GRINDER_CATEGORY);
        registry.addCategory(MEAT_HOOK_CATEGORY);
        registry.addWorkstation(BUTCHER_BLOCK_CATEGORY, (EmiIngredient)BUTCHER_BLOCK_WORKSTATION);
        registry.addWorkstation(GRINDER_CATEGORY, (EmiIngredient)GRINDER_WORKSTATION);
        registry.addWorkstation(MEAT_HOOK_CATEGORY, (EmiIngredient)MEAT_HOOK_WORKSTATION);
        RecipeManager recipeManager = registry.getRecipeManager();
        recipeManager.getAllRecipesFor((RecipeType)ButchercraftRecipes.BUTCHER_BLOCK.get()).stream().map(holder -> new ButcherBlockEmiRecipe((ButcherBlockRecipe)holder.value(), holder.id())).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        recipeManager.getAllRecipesFor((RecipeType)ButchercraftRecipes.GRINDER.get()).stream().map(holder -> new GrinderEmiRecipe((GrinderRecipe)holder.value(), holder.id())).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        recipeManager.getAllRecipesFor((RecipeType)ButchercraftRecipes.HOOK.get()).stream().map(holder -> new MeatHookEmiRecipe((HookRecipe)holder.value(), holder.id())).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }
}

