/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.entity.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.crafting.Ingredient;

public class LivingTemptGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();
    private final TargetingConditions targetingConditions;
    protected final PathfinderMob mob;
    private final double speedModifier;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    @Nullable
    protected LivingEntity entity;
    private int calmDown;
    private boolean isRunning;
    public final Ingredient items;
    private final boolean canScare;

    public LivingTemptGoal(PathfinderMob pMob, double pSpeedModifier, Ingredient pItems, boolean pCanScare) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.items = pItems;
        this.canScare = pCanScare;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.copy().selector(this::shouldFollow);
    }

    public boolean canUse() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.entity = this.mob.level().getNearestEntity(LivingEntity.class, this.targetingConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ(), this.mob.getBoundingBox().inflate(5.0));
        return this.entity != null;
    }

    public boolean shouldFollow(LivingEntity p_148139_) {
        return this.items.test(p_148139_.getMainHandItem()) || this.items.test(p_148139_.getOffhandItem());
    }

    public boolean canContinueToUse() {
        if (this.canScare()) {
            if (this.mob.distanceToSqr((Entity)this.entity) < 36.0) {
                if (this.entity.distanceToSqr(this.px, this.py, this.pz) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.entity.getXRot() - this.pRotX) > 5.0 || Math.abs((double)this.entity.getYRot() - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.entity.getX();
                this.py = this.entity.getY();
                this.pz = this.entity.getZ();
            }
            this.pRotX = this.entity.getXRot();
            this.pRotY = this.entity.getYRot();
        }
        return this.canUse();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void start() {
        this.px = this.entity.getX();
        this.py = this.entity.getY();
        this.pz = this.entity.getZ();
        this.isRunning = true;
    }

    public void stop() {
        this.entity = null;
        this.mob.getNavigation().stop();
        this.calmDown = LivingTemptGoal.reducedTickDelay((int)100);
        this.isRunning = false;
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.entity, (float)(this.mob.getMaxHeadYRot() + 20), (float)this.mob.getMaxHeadXRot());
        if (this.mob.distanceToSqr((Entity)this.entity) < 6.25) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.entity, this.speedModifier);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

