/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.data.builders.recipes;

import com.lance5057.butchercraft.ButchercraftRecipeSerializers;
import com.lance5057.butchercraft.data.builders.recipes.RecipeBuilderUtil;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipeSerializer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class GrinderRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final Ingredient ingredient;
    private final int ingredientCount;
    private final Ingredient attachment;
    private final int resultCount;
    private final int grinds;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private final GrinderRecipeSerializer serializer;

    private GrinderRecipeBuilder(RecipeCategory pCategory, ItemLike pResult, Ingredient pIngredient, Ingredient attachment, int pGrind, int count, GrinderRecipeSerializer serializer, int ingredientCount) {
        this.category = pCategory;
        this.result = pResult.asItem();
        this.ingredient = pIngredient;
        this.ingredientCount = ingredientCount;
        this.attachment = attachment;
        this.resultCount = count;
        this.grinds = pGrind;
        this.serializer = serializer;
        this.unlockedBy(RecipeBuilderUtil.getHasName((ItemLike)pIngredient.getItems()[0].getItem()), RecipeBuilderUtil.has((ItemLike)pIngredient.getItems()[0].getItem()));
    }

    public static GrinderRecipeBuilder grind(Ingredient pIngredient, RecipeCategory pCategory, int ingredientCount, Ingredient attachment, ItemLike pResult, int grinds, int resultCount) {
        return new GrinderRecipeBuilder(pCategory, pResult, pIngredient, attachment, grinds, resultCount, (GrinderRecipeSerializer)ButchercraftRecipeSerializers.GRINDER_SERIALIZER.get(), ingredientCount);
    }

    public RecipeBuilder unlockedBy(String pCriterionName, Criterion<?> pCriterionTrigger) {
        this.criteria.put(pCriterionName, pCriterionTrigger);
        return this;
    }

    public GrinderRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput pFinishedRecipeConsumer) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)this.result);
        this.save(pFinishedRecipeConsumer, "butchercraft:mortar/" + location.getPath());
    }

    public void save(RecipeOutput pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.validate(pRecipeId);
        Advancement.Builder builder = pFinishedRecipeConsumer.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pRecipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pRecipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        ResourceLocation r = ResourceLocation.fromNamespaceAndPath((String)pRecipeId.getNamespace(), (String)("recipes/" + this.category.getFolderName() + "/" + pRecipeId.getPath()));
        pFinishedRecipeConsumer.accept(pRecipeId, (Recipe)new GrinderRecipe(this.group == null ? "" : this.group, this.ingredient, this.ingredientCount, this.attachment, new ItemStack((ItemLike)this.result, this.resultCount), this.grinds), builder.build(r));
    }

    private void validate(ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
        }
    }
}

