/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.data.builders.recipes;

import com.lance5057.butchercraft.client.BlacklistedModel;
import com.lance5057.butchercraft.data.builders.recipes.RecipeBuilderUtil;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.bases.recipes.RecipeMobEffect;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockRecipe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;

public class ButcherBlockRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final List<AnimatedRecipeItemUse> tools = NonNullList.create();
    private final List<Ingredient> jei = NonNullList.create();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private String group;

    public ButcherBlockRecipeBuilder(Item carcassIn) {
        this.result = carcassIn;
        this.unlockedBy(RecipeBuilderUtil.getHasName((ItemLike)carcassIn), RecipeBuilderUtil.has((ItemLike)carcassIn));
    }

    public static ButcherBlockRecipeBuilder shapedRecipe(Item resultIn) {
        return new ButcherBlockRecipeBuilder(resultIn);
    }

    public ButcherBlockRecipeBuilder tool(Ingredient tool, int count, int uses, boolean damage, ResourceKey<LootTable> table, List<RecipeMobEffect> effect, BlacklistedModel ... model) {
        this.tools.add(new AnimatedRecipeItemUse(uses, tool, count, damage, table.location(), effect, List.of(model)));
        return this;
    }

    public ButcherBlockRecipeBuilder tool(Ingredient tool, int uses, boolean damage, ResourceKey<LootTable> table, List<RecipeMobEffect> effect, BlacklistedModel ... model) {
        this.tools.add(new AnimatedRecipeItemUse(uses, tool, 1, damage, table.location(), effect, List.of(model)));
        return this;
    }

    public ButcherBlockRecipeBuilder JEIIngredient(Ingredient i) {
        this.jei.add(i);
        return this;
    }

    private void validate(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
        if (this.tools.isEmpty()) {
            throw new IllegalStateException("No toolset is defined for shaped recipe %s!".formatted(id));
        }
    }

    public RecipeBuilder unlockedBy(String pCriterionName, Criterion<?> pCriterionTrigger) {
        this.criteria.put(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder group(String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput consumerIn, ResourceLocation pRecipeId) {
        this.validate(pRecipeId);
        Advancement.Builder builder = consumerIn.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pRecipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pRecipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        consumerIn.accept(pRecipeId, (Recipe)new ButcherBlockRecipe(this.group == null ? "" : this.group, Ingredient.of((ItemLike[])new ItemLike[]{this.result}), (NonNullList<AnimatedRecipeItemUse>)NonNullList.copyOf(this.tools), (NonNullList<Ingredient>)NonNullList.copyOf(this.jei)), builder.build(ResourceLocation.fromNamespaceAndPath((String)pRecipeId.getNamespace(), (String)("recipes/meat_hook/" + pRecipeId.getPath()))));
    }
}

