/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.data;

import com.lance5057.butchercraft.Butchercraft;
import com.lance5057.butchercraft.data.builders.Advancements;
import com.lance5057.butchercraft.data.builders.BlockModels;
import com.lance5057.butchercraft.data.builders.BlockTagGenerator;
import com.lance5057.butchercraft.data.builders.ButchercraftEntityTypeTagsProvider;
import com.lance5057.butchercraft.data.builders.ButchercraftFluidTagGenerator;
import com.lance5057.butchercraft.data.builders.ButchercraftLootTableProvider;
import com.lance5057.butchercraft.data.builders.DataMapGen;
import com.lance5057.butchercraft.data.builders.EnglishLoc;
import com.lance5057.butchercraft.data.builders.ItemModels;
import com.lance5057.butchercraft.data.builders.ItemTagGenerator;
import com.lance5057.butchercraft.data.builders.PoiTagGenerator;
import com.lance5057.butchercraft.data.builders.recipes.ButchercraftRecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="butchercraft", bus=EventBusSubscriber.Bus.MOD)
public class DataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        Butchercraft.logger.info("Data Generator Started!");
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        Advancements advancements = new Advancements();
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(output, lookupProvider, existingFileHelper, List.of(advancements)));
        generator.addProvider(true, (DataProvider)new ItemModels(output, existingFileHelper));
        generator.addProvider(true, (DataProvider)new BlockModels(output, existingFileHelper));
        generator.addProvider(true, (DataProvider)new EnglishLoc(output));
        BlockTagGenerator btg = new BlockTagGenerator(output, lookupProvider, existingFileHelper);
        generator.addProvider(true, (DataProvider)btg);
        generator.addProvider(true, (DataProvider)new ItemTagGenerator(output, lookupProvider, btg.contentsGetter(), existingFileHelper));
        generator.addProvider(true, (DataProvider)new ButchercraftFluidTagGenerator(output, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ButchercraftRecipeProvider(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new ButchercraftLootTableProvider(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new ButchercraftEntityTypeTagsProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new PoiTagGenerator(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapGen(output, lookupProvider));
    }
}

