/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.client.rendering.animation.floats;

import com.lance5057.butchercraft.client.rendering.animation.floats.AnimatedFloatVector3;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class AnimationFloatTransform {
    public static final Codec<AnimationFloatTransform> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)AnimatedFloatVector3.CODEC.fieldOf("location").forGetter(a -> a.loc), (App)AnimatedFloatVector3.CODEC.fieldOf("scale").forGetter(a -> a.scale), (App)AnimatedFloatVector3.CODEC.fieldOf("rotation").forGetter(a -> a.rot)).apply((Applicative)inst, AnimationFloatTransform::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnimationFloatTransform> STREAM_CODEC = StreamCodec.of(AnimationFloatTransform::write, AnimationFloatTransform::read);
    AnimatedFloatVector3 loc;
    AnimatedFloatVector3 scale;
    AnimatedFloatVector3 rot;
    public static AnimationFloatTransform ZERO = new AnimationFloatTransform(AnimatedFloatVector3.ZERO, AnimatedFloatVector3.ZERO, AnimatedFloatVector3.ZERO);
    public static AnimationFloatTransform ONE = new AnimationFloatTransform(AnimatedFloatVector3.ONE, AnimatedFloatVector3.ONE, AnimatedFloatVector3.ONE);

    public AnimationFloatTransform() {
        this.loc = AnimatedFloatVector3.ZERO;
        this.rot = AnimatedFloatVector3.ZERO;
        this.scale = AnimatedFloatVector3.ONE;
    }

    public AnimationFloatTransform(AnimatedFloatVector3 l, AnimatedFloatVector3 s, AnimatedFloatVector3 r) {
        this.loc = l;
        this.scale = s;
        this.rot = r;
    }

    public void animate(float time) {
        this.loc.animate(time);
        this.scale.animate(time);
        this.rot.animate(time);
    }

    public AnimationFloatTransform setLocation(AnimatedFloatVector3 in) {
        this.loc = in;
        return this;
    }

    public AnimationFloatTransform setRotation(AnimatedFloatVector3 in) {
        this.rot = in;
        return this;
    }

    public AnimationFloatTransform setScale(AnimatedFloatVector3 in) {
        this.scale = in;
        return this;
    }

    public AnimatedFloatVector3 getLocation() {
        return this.loc;
    }

    public AnimatedFloatVector3 getScale() {
        return this.scale;
    }

    public AnimatedFloatVector3 getRotation() {
        return this.rot;
    }

    private static AnimationFloatTransform read(RegistryFriendlyByteBuf buffer) {
        AnimatedFloatVector3 l = (AnimatedFloatVector3)AnimatedFloatVector3.STREAM_CODEC.decode((Object)buffer);
        AnimatedFloatVector3 r = (AnimatedFloatVector3)AnimatedFloatVector3.STREAM_CODEC.decode((Object)buffer);
        AnimatedFloatVector3 s = (AnimatedFloatVector3)AnimatedFloatVector3.STREAM_CODEC.decode((Object)buffer);
        return new AnimationFloatTransform(l, s, r);
    }

    private static void write(RegistryFriendlyByteBuf buffer, AnimationFloatTransform af) {
        AnimatedFloatVector3.STREAM_CODEC.encode((Object)buffer, (Object)af.loc);
        AnimatedFloatVector3.STREAM_CODEC.encode((Object)buffer, (Object)af.rot);
        AnimatedFloatVector3.STREAM_CODEC.encode((Object)buffer, (Object)af.scale);
    }
}

