/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.client.rendering.animation.floats;

import com.lance5057.butchercraft.client.rendering.animation.floats.AnimatedFloat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class AnimatedFloatVector3 {
    public static final Codec<AnimatedFloatVector3> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)AnimatedFloat.CODEC.optionalFieldOf("x", (Object)AnimatedFloat.ZERO).forGetter(a -> a.x), (App)AnimatedFloat.CODEC.optionalFieldOf("y", (Object)AnimatedFloat.ZERO).forGetter(a -> a.y), (App)AnimatedFloat.CODEC.optionalFieldOf("z", (Object)AnimatedFloat.ZERO).forGetter(a -> a.z)).apply((Applicative)inst, AnimatedFloatVector3::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnimatedFloatVector3> STREAM_CODEC = StreamCodec.of(AnimatedFloatVector3::write, AnimatedFloatVector3::read);
    AnimatedFloat x;
    AnimatedFloat y;
    AnimatedFloat z;
    public static AnimatedFloatVector3 ZERO = new AnimatedFloatVector3(AnimatedFloat.ZERO, AnimatedFloat.ZERO, AnimatedFloat.ZERO);
    public static AnimatedFloatVector3 ONE = new AnimatedFloatVector3(AnimatedFloat.ONE, AnimatedFloat.ONE, AnimatedFloat.ONE);

    public AnimatedFloatVector3() {
        this.x = AnimatedFloat.ZERO;
        this.y = AnimatedFloat.ZERO;
        this.z = AnimatedFloat.ZERO;
    }

    public AnimatedFloatVector3(AnimatedFloat x, AnimatedFloat y, AnimatedFloat z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public AnimatedFloatVector3 setX(AnimatedFloat in) {
        this.x = in;
        return this;
    }

    public AnimatedFloatVector3 setY(AnimatedFloat in) {
        this.y = in;
        return this;
    }

    public AnimatedFloatVector3 setZ(AnimatedFloat in) {
        this.z = in;
        return this;
    }

    public AnimatedFloatVector3 setAll(AnimatedFloat in) {
        this.x = in;
        this.y = in;
        this.z = in;
        return this;
    }

    public void animate(float time) {
        this.x.animate(time);
        this.y.animate(time);
        this.z.animate(time);
    }

    public AnimatedFloat getX() {
        return this.x;
    }

    public AnimatedFloat getY() {
        return this.y;
    }

    public AnimatedFloat getZ() {
        return this.z;
    }

    public void setMax(float x, float y, float z) {
        this.getX().setMax(x);
        this.getY().setMax(y);
        this.getZ().setMax(z);
    }

    public void setMin(float x, float y, float z) {
        this.getX().setMin(x);
        this.getY().setMin(y);
        this.getZ().setMin(z);
    }

    public void setSpeed(float speed) {
        this.getX().setSpeed(speed);
        this.getY().setSpeed(speed);
        this.getZ().setSpeed(speed);
    }

    private static AnimatedFloatVector3 read(RegistryFriendlyByteBuf buffer) {
        AnimatedFloat x = (AnimatedFloat)AnimatedFloat.STREAM_CODEC.decode((Object)buffer);
        AnimatedFloat y = (AnimatedFloat)AnimatedFloat.STREAM_CODEC.decode((Object)buffer);
        AnimatedFloat z = (AnimatedFloat)AnimatedFloat.STREAM_CODEC.decode((Object)buffer);
        return new AnimatedFloatVector3(x, y, z);
    }

    private static void write(RegistryFriendlyByteBuf buffer, AnimatedFloatVector3 af) {
        AnimatedFloat.STREAM_CODEC.encode((Object)buffer, (Object)af.x);
        AnimatedFloat.STREAM_CODEC.encode((Object)buffer, (Object)af.y);
        AnimatedFloat.STREAM_CODEC.encode((Object)buffer, (Object)af.z);
    }
}

