/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.client.rendering.animation.floats;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class AnimatedFloat {
    public static final Codec<AnimatedFloat> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.optionalFieldOf("min", (Object)Float.valueOf(0.0f)).forGetter(a -> Float.valueOf(a.iMin)), (App)Codec.FLOAT.optionalFieldOf("max", (Object)Float.valueOf(0.0f)).forGetter(a -> Float.valueOf(a.iMax)), (App)Codec.FLOAT.optionalFieldOf("offset", (Object)Float.valueOf(0.0f)).forGetter(a -> Float.valueOf(a.offset)), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(0.0f)).forGetter(a -> Float.valueOf(a.speed)), (App)Codec.BOOL.optionalFieldOf("loop", (Object)false).forGetter(a -> a.loop), (App)Codec.BOOL.optionalFieldOf("pingpong", (Object)false).forGetter(a -> a.pingpong)).apply((Applicative)inst, AnimatedFloat::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnimatedFloat> STREAM_CODEC = StreamCodec.of(AnimatedFloat::write, AnimatedFloat::read);
    float iMin;
    float iMax;
    float offset;
    float speed;
    boolean loop;
    boolean pingpong;
    public static AnimatedFloat ZERO = new AnimatedFloat(0.0f, 0.0f, 0.0f);
    public static AnimatedFloat ONE = new AnimatedFloat(1.0f, 1.0f, 1.0f);

    public AnimatedFloat(float iMax) {
        this(iMax == 0.0f ? 0.0f : -iMax, iMax, 1.0f);
    }

    public AnimatedFloat(float iMax, float speed) {
        this(iMax == 0.0f ? 0.0f : -iMax, iMax, speed);
    }

    public AnimatedFloat(float iMin, float iMax, float speed) {
        this.iMin = iMin;
        this.iMax = iMax;
        this.speed = speed;
    }

    public AnimatedFloat(float iMin, float iMax, float offset, float speed, boolean loop, boolean pingpong) {
        this.iMin = iMin;
        this.iMax = iMax;
        this.speed = speed;
        this.offset = offset;
        this.loop = loop;
        this.pingpong = pingpong;
    }

    public float animate(float time) {
        float t2;
        float mod = this.iMax - this.iMin;
        if (mod == 0.0f) {
            return 0.0f;
        }
        float t = time * this.speed % mod;
        if (this.pingpong && (t2 = time * this.speed % (mod * 2.0f)) >= mod) {
            t = mod - t;
        }
        if (!this.loop && t + this.speed >= this.iMax) {
            this.speed = 0.0f;
        }
        if (this.speed == 0.0f) {
            return this.iMax;
        }
        return t + this.iMin;
    }

    public float getMax() {
        return this.iMax;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setMax(float m) {
        this.iMax = m;
    }

    public void setMin(float m) {
        this.iMin = m;
    }

    public void setSpeed(float s) {
        this.speed = s;
    }

    private static AnimatedFloat read(RegistryFriendlyByteBuf buffer) {
        float min = buffer.readFloat();
        float max = buffer.readFloat();
        float offset = buffer.readFloat();
        float speed = buffer.readFloat();
        boolean loop = buffer.readBoolean();
        boolean pingpong = buffer.readBoolean();
        return new AnimatedFloat(min, max, offset, speed, loop, pingpong);
    }

    private static void write(RegistryFriendlyByteBuf buffer, AnimatedFloat af) {
        buffer.writeFloat(af.iMin);
        buffer.writeFloat(af.iMax);
        buffer.writeFloat(af.offset);
        buffer.writeFloat(af.speed);
        buffer.writeBoolean(af.loop);
        buffer.writeBoolean(af.pingpong);
    }
}

