/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.client;

import com.lance5057.butchercraft.client.rendering.animation.floats.AnimationFloatTransform;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public record BlacklistedModel(ResourceLocation rc, boolean isBlock, AnimationFloatTransform transform) {
    public static final Codec<BlacklistedModel> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(BlacklistedModel::rc), (App)Codec.BOOL.optionalFieldOf("IsBlock", (Object)false).forGetter(BlacklistedModel::isBlock), (App)AnimationFloatTransform.CODEC.fieldOf("animation").forGetter(BlacklistedModel::transform)).apply((Applicative)inst, BlacklistedModel::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlacklistedModel> STREAM_CODEC = StreamCodec.of(BlacklistedModel::write, BlacklistedModel::read);
    public static BlacklistedModel empty = new BlacklistedModel(ResourceLocation.fromNamespaceAndPath((String)"", (String)""), true, AnimationFloatTransform.ZERO);

    public BlacklistedModel(Item item, AnimationFloatTransform anim) {
        this(BuiltInRegistries.ITEM.getKey((Object)item), false, anim);
    }

    private static BlacklistedModel read(RegistryFriendlyByteBuf buffer) {
        ResourceLocation rc = buffer.readResourceLocation();
        boolean block = buffer.readBoolean();
        AnimationFloatTransform t = (AnimationFloatTransform)AnimationFloatTransform.STREAM_CODEC.decode((Object)buffer);
        return new BlacklistedModel(rc, block, t);
    }

    private static void write(RegistryFriendlyByteBuf buffer, BlacklistedModel bm) {
        buffer.writeResourceLocation(bm.rc);
        buffer.writeBoolean(bm.isBlock);
        AnimationFloatTransform.STREAM_CODEC.encode((Object)buffer, (Object)bm.transform);
    }
}

